/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.preferences;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerCompose;
import org.eclipse.linuxtools.internal.docker.ui.preferences.PreferenceMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DockerComposePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private DirectoryFieldEditor dockerComposeInstallDir;

    public DockerComposePreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(PreferenceMessages.getString("DockerCompose.message"));
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.dockerComposeInstallDir = new CustomDirectoryFieldEditor("dockerComposeInstallDir", PreferenceMessages.getString("DockerComposePath.label"), this.getFieldEditorParent()){

            protected boolean checkState() {
                if (this.isEmptyStringAllowed() && !this.getStringValue().isEmpty()) {
                    boolean validPath = super.checkState();
                    if (!validPath) {
                        return false;
                    }
                    if (!DockerCompose.getInstance().checkPathToDockerCompose(this.getStringValue())) {
                        DockerComposePreferencePage.this.setWarningMessage(NLS.bind((String)Messages.Docker_Compose_Command_Not_Found, (Object)this.getStringValue()));
                        return true;
                    }
                }
                DockerComposePreferencePage.this.setMessage("");
                return true;
            }
        };
        this.addField((FieldEditor)this.dockerComposeInstallDir);
        this.dockerComposeInstallDir.setPreferenceStore(this.getPreferenceStore());
        this.dockerComposeInstallDir.setEmptyStringAllowed(true);
        this.dockerComposeInstallDir.setValidateStrategy(0);
        this.dockerComposeInstallDir.setPage((DialogPage)this);
        this.dockerComposeInstallDir.setErrorMessage(PreferenceMessages.getString("DockerComposePath.invalid.label"));
        this.dockerComposeInstallDir.showErrorMessage();
        this.dockerComposeInstallDir.load();
    }

    private void setWarningMessage(String message) {
        super.setMessage(message, 2);
    }

    private static class CustomDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public CustomDirectoryFieldEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
            this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
            this.setValidateStrategy(0);
            this.createControl(parent);
        }
    }
}

