/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.List;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.cdt.make.internal.ui.text.ColorManager;
import org.eclipse.cdt.make.internal.ui.text.makefile.AbstractMakefileCodeScanner;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileAnnotationHover;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileCodeScanner;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileCompletionProcessor;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefilePartitionScanner;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileReconcilingStrategy;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileTextHover;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class MakefileSourceConfiguration
extends TextSourceViewerConfiguration {
    private ColorManager fColorManager;
    MakefileCodeScanner fCodeScanner;
    private MakefileEditor fEditor;
    private SingleTokenScanner fCommentScanner;

    public MakefileSourceConfiguration(IPreferenceStore preferenceStore, MakefileEditor editor) {
        super(preferenceStore);
        this.fEditor = editor;
        this.fColorManager = ColorManager.getDefault();
    }

    public String[] getConfiguredContentTypes(ISourceViewer v) {
        return MakefilePartitionScanner.MAKE_PARTITIONS;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fEditor != null && this.fEditor.isEditable()) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            assistant.setContentAssistProcessor((IContentAssistProcessor)new MakefileCompletionProcessor((IEditorPart)this.fEditor), "__dftl_partition_content_type");
            assistant.setContentAssistProcessor((IContentAssistProcessor)new MakefileCompletionProcessor((IEditorPart)this.fEditor), "makefile_comment");
            assistant.enableAutoActivation(true);
            assistant.setAutoActivationDelay(500);
            assistant.setProposalPopupOrientation(10);
            assistant.setContextInformationPopupOrientation(20);
            assistant.setContextInformationPopupBackground(this.fColorManager.getColor(new RGB(255, 255, 255)));
            assistant.setInformationControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, false);
                }
            });
            return assistant;
        }
        return null;
    }

    protected MakefileCodeScanner getCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new MakefileCodeScanner();
        }
        return this.fCodeScanner;
    }

    protected ITokenScanner getCommentScanner() {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new SingleTokenScanner("org.eclipse.cdt.make.ui.editor.comment");
        }
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer v) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(v));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer(this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "makefile_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "makefile_comment");
        return reconciler;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "___makefile_partitioning";
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fEditor != null && this.fEditor.isEditable()) {
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)new MakefileReconcilingStrategy(this.fEditor), false);
            reconciler.setDelay(1000);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            return reconciler;
        }
        return null;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#"};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fEditor != null) {
            return new MakefileTextHover((IEditorPart)this.fEditor);
        }
        return super.getTextHover(sourceViewer, contentType);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fEditor != null) {
            return new MakefileAnnotationHover((IEditorPart)this.fEditor);
        }
        return super.getAnnotationHover(sourceViewer);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        if (this.fCodeScanner != null && this.fCodeScanner.affectsBehavior(event)) {
            return true;
        }
        return this.fCommentScanner != null && this.fCommentScanner.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner != null) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner != null) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
    }

    static class SingleTokenScanner
    extends AbstractMakefileCodeScanner {
        private final String[] fProperties;

        public SingleTokenScanner(String property) {
            this.fProperties = new String[]{property};
            this.initialize();
        }

        @Override
        protected List<IRule> createRules() {
            this.setDefaultReturnToken((IToken)this.getToken(this.fProperties[0]));
            return null;
        }

        @Override
        protected String[] getTokenProperties() {
            return this.fProperties;
        }
    }
}

