/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryBytesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MIDataReadMemoryBytes
extends MICommand<MIDataReadMemoryBytesInfo> {
    private static final int DEFAULT_ADDRESSABLE_SIZE = 1;
    private int fCount;
    private int fword_size;

    public MIDataReadMemoryBytes(IDMContext ctx, String address, long offset, int count) {
        this(ctx, address, offset, count, 1);
    }

    public MIDataReadMemoryBytes(IDMContext ctx, String address, long offset, int count, int word_size) {
        super(ctx, "-data-read-memory-bytes");
        this.fCount = count;
        this.fword_size = word_size;
        if (offset != 0L) {
            this.setOptions(new String[]{"-o", Long.toString(offset)});
        }
        this.setParameters(new String[]{address, Integer.toString(count)});
    }

    @Override
    public MIDataReadMemoryBytesInfo getResult(MIOutput out) {
        return new MIDataReadMemoryBytesInfo(out, this.fCount, this.fword_size);
    }
}

