/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.debugsources;

import java.io.File;
import java.util.Set;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.DebugSourcesTreeElement;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class DebugSourcesLabelProvider
extends ColumnLabelProvider {
    private int index;
    private boolean flattenFoldersWithNoFiles = true;
    private boolean showExistingFilesOnly = true;

    public DebugSourcesLabelProvider(int index) {
        this.index = index;
    }

    public void setFlattenFoldersWithNoFiles(boolean flattenFoldersWithNoFiles) {
        this.flattenFoldersWithNoFiles = flattenFoldersWithNoFiles;
    }

    public boolean isFlattenFoldersWithNoFiles() {
        return this.flattenFoldersWithNoFiles;
    }

    public void setShowExistingFilesOnly(boolean showExistingFilesOnly) {
        this.showExistingFilesOnly = showExistingFilesOnly;
    }

    public boolean isShowExistingFilesOnly() {
        return this.showExistingFilesOnly;
    }

    public String getText(Object element) {
        return this.getLabel(element, this.index);
    }

    private String getLabel(Object element, int columnIdx) {
        String emptyString = "";
        if (element instanceof DebugSourcesTreeElement) {
            DebugSourcesTreeElement node = (DebugSourcesTreeElement)element;
            if (columnIdx == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(node.getName());
                if (this.flattenFoldersWithNoFiles) {
                    DebugSourcesTreeElement child;
                    Set<DebugSourcesTreeElement> children;
                    while (node.getFullPath() == null && (children = node.getChildren(this.showExistingFilesOnly)).size() == 1 && (child = children.iterator().next()).getFullPath() == null) {
                        node = child;
                        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != File.separatorChar) {
                            sb.append(File.separatorChar);
                        }
                        sb.append(node.getName());
                    }
                }
                return sb.toString();
            }
            if (columnIdx == 1) {
                return node.hasChildren() ? emptyString : node.getFullPath();
            }
        }
        return emptyString;
    }

    public Color getForeground(Object element) {
        DebugSourcesTreeElement node;
        if (this.index == 1 && element instanceof DebugSourcesTreeElement && (node = (DebugSourcesTreeElement)element).getExists() == DebugSourcesTreeElement.FileExist.NO) {
            return Display.getDefault().getSystemColor(15);
        }
        return super.getForeground(element);
    }

    public Font getFont(Object element) {
        return super.getFont(element);
    }
}

