/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class MapEntrySourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = CDebugCorePlugin.getUniqueIdentifier() + ".containerType.mapEntry";
    private IPath fLocalPath;
    private String fBackendPathStr;

    public MapEntrySourceContainer() {
        this.fBackendPathStr = "";
        this.fLocalPath = Path.EMPTY;
    }

    public MapEntrySourceContainer(String backendPathStr, IPath local) {
        this.fBackendPathStr = backendPathStr;
        this.fLocalPath = local;
    }

    @Deprecated
    public static IPath createPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.matches("^([a-zA-Z])[:](.*)$")) {
            String device = null;
            String missingfile = path.replace("\\", "/");
            int idx = missingfile.indexOf(":");
            if (idx > 0) {
                device = missingfile.substring(0, idx + 1);
                missingfile = missingfile.substring(idx + 1);
            }
            return new Path(device, missingfile);
        }
        int idx = 0;
        if (path.startsWith("//")) {
            String network;
            idx = path.indexOf("/", 2);
            if (idx > 0) {
                network = path.substring(0, idx);
                path = path.substring(idx);
            } else {
                network = path;
                path = "";
            }
            return new Path(network, path).makeUNC(true);
        }
        return new Path(path);
    }

    public Object[] findSourceElements(String name) throws CoreException {
        IPath path = null;
        if (name != null) {
            String backend = this.getBackendPathStr();
            if (name.toLowerCase().startsWith(backend.toLowerCase())) {
                String suffix = name.substring(backend.length());
                if (backend.endsWith("/") || backend.endsWith("\\") || suffix.startsWith("/") || suffix.startsWith("\\")) {
                    path = this.getLocalPath().append(suffix);
                }
            }
            if (path == null) {
                IPath input = MapEntrySourceContainer.createPath(name);
                IPath backendPath = MapEntrySourceContainer.createPath(backend);
                if (backendPath.isPrefixOf(input)) {
                    IPath suffix = input.removeFirstSegments(backendPath.segmentCount());
                    path = this.getLocalPath().append(suffix);
                }
            }
        }
        if (path != null) {
            ICProject project;
            String projectName;
            ILaunchConfiguration launchConfiguration;
            IFile[] wsFiles = ResourceLookup.findFilesForLocation(path);
            ArrayList<IFile> list = new ArrayList<IFile>();
            int j = 0;
            while (j < wsFiles.length) {
                if (wsFiles[j].exists()) {
                    list.add(wsFiles[j]);
                    if (!this.isFindDuplicates()) break;
                }
                ++j;
            }
            if (list.size() > 0) {
                return list.toArray();
            }
            File file = path.toFile();
            ISourceLookupDirector director = this.getDirector();
            if (director != null && file.exists() && file.isFile() && (launchConfiguration = director.getLaunchConfiguration()) != null && (projectName = launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "")).length() > 0 && (project = CoreModel.getDefault().getCModel().getCProject(projectName)) != null) {
                try {
                    IPath location = Path.fromOSString((String)file.getCanonicalPath());
                    String id = CoreModel.getRegistedContentTypeId((IProject)project.getProject(), (String)location.lastSegment());
                    return new ExternalTranslationUnit[]{new ExternalTranslationUnit((ICElement)project, location, id)};
                }
                catch (IOException e) {
                    CDebugCorePlugin.log(e);
                }
            }
            if (file.exists() && file.isFile()) {
                return new Object[]{new LocalFileStorage(file)};
            }
        }
        return EMPTY;
    }

    public String getName() {
        return MessageFormat.format("{0} - {1}", this.getBackendPathStr(), this.getLocalPath().toOSString());
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public IPath getLocalPath() {
        return this.fLocalPath;
    }

    public String getBackendPathStr() {
        return this.fBackendPathStr;
    }

    public void setLocalPath(IPath local) {
        this.fLocalPath = local;
    }

    public void setBackendPathStr(String backendPathStr) {
        this.fBackendPathStr = backendPathStr;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapEntrySourceContainer)) {
            return false;
        }
        MapEntrySourceContainer entry = (MapEntrySourceContainer)((Object)o);
        return entry.getBackendPathStr().equals(this.getBackendPathStr()) && entry.getLocalPath().equals((Object)this.getLocalPath());
    }

    public MapEntrySourceContainer copy() {
        return new MapEntrySourceContainer(this.fBackendPathStr, this.fLocalPath);
    }
}

