/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.internal.core.breakpoints.AbstractLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.AbstractTracepoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CEventBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IBreakpointImportParticipant;

public class CBreakpointImportParticipant
implements IBreakpointImportParticipant {
    public boolean matches(Map<String, Object> attributes, IBreakpoint breakpoint) throws CoreException {
        if (attributes == null || breakpoint == null) {
            return false;
        }
        String type = (String)attributes.get("type");
        if (type == null) {
            return false;
        }
        if (!breakpoint.getMarker().getType().equals(type)) {
            return false;
        }
        if (breakpoint instanceof AbstractLineBreakpoint) {
            return this.matchesLineBreakpoint(attributes, (AbstractLineBreakpoint)breakpoint);
        }
        if (breakpoint instanceof AbstractTracepoint) {
            return this.matchesTracepoint(attributes, (AbstractTracepoint)breakpoint);
        }
        if (breakpoint instanceof CEventBreakpoint) {
            return this.matchesEventBreakpoint(attributes, (CEventBreakpoint)breakpoint);
        }
        if (breakpoint instanceof CWatchpoint) {
            return this.matchesWatchpoint(attributes, (CWatchpoint)breakpoint);
        }
        return false;
    }

    public void verify(IBreakpoint breakpoint) throws CoreException {
    }

    private boolean attributesEqual(Object attr1, Object attr2) {
        if (attr1 == null) {
            return attr2 == null;
        }
        return attr1.equals(attr2);
    }

    private boolean matchesLineBreakpoint(Map<String, Object> attributes, AbstractLineBreakpoint breakpoint) throws CoreException {
        int lineNumber;
        Integer line = (Integer)attributes.get("lineNumber");
        int n = lineNumber = line == null ? -1 : line;
        return breakpoint.getLineNumber() == lineNumber && this.attributesEqual(breakpoint.getType(), attributes.get("org.eclipse.cdt.debug.core.breakpointType")) && this.attributesEqual(breakpoint.getSourceHandle(), attributes.get("org.eclipse.cdt.debug.core.sourceHandle")) && this.attributesEqual(breakpoint.getMarker().getAttribute("org.eclipse.cdt.debug.core.address"), attributes.get("org.eclipse.cdt.debug.core.address")) && this.attributesEqual(breakpoint.getMarker().getAttribute("org.eclipse.cdt.debug.core.function"), attributes.get("org.eclipse.cdt.debug.core.function"));
    }

    private boolean matchesTracepoint(Map<String, Object> attributes, AbstractTracepoint tracepoint) throws CoreException {
        int lineNumber;
        Integer line = (Integer)attributes.get("lineNumber");
        int n = lineNumber = line == null ? -1 : line;
        return tracepoint.getLineNumber() == lineNumber && this.attributesEqual(tracepoint.getType(), attributes.get("org.eclipse.cdt.debug.core.breakpointType")) && this.attributesEqual(tracepoint.getSourceHandle(), attributes.get("org.eclipse.cdt.debug.core.sourceHandle")) && this.attributesEqual(tracepoint.getMarker().getAttribute("org.eclipse.cdt.debug.core.address"), attributes.get("org.eclipse.cdt.debug.core.address")) && this.attributesEqual(tracepoint.getMarker().getAttribute("org.eclipse.cdt.debug.core.function"), attributes.get("org.eclipse.cdt.debug.core.function"));
    }

    private boolean matchesEventBreakpoint(Map<String, Object> attributes, CEventBreakpoint breakpoint) throws CoreException {
        return breakpoint.getEventArgument().equals(attributes.get("org.eclipse.cdt.debug.core.eventbreakpoint_event_arg")) && this.attributesEqual(breakpoint.getEventType(), attributes.get("org.eclipse.cdt.debug.core.eventbreakpoint_event_id"));
    }

    private boolean matchesWatchpoint(Map<String, Object> attributes, CWatchpoint watchpoint) throws CoreException {
        return watchpoint.getExpression().equals(attributes.get("org.eclipse.cdt.debug.core.expression")) && this.attributesEqual(watchpoint.getType(), attributes.get("org.eclipse.cdt.debug.core.breakpointType"));
    }
}

