/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.service;

import org.eclipse.cdt.dsf.debug.service.IExpressions;

public interface IExpressions2
extends IExpressions {
    public ICastedExpressionDMContext createCastedExpression(IExpressions.IExpressionDMContext var1, CastInfo var2);

    public static class CastInfo {
        private final String typeString;
        private final int arrayCount;
        private final int arrayStart;

        public CastInfo(String typeString, int arrayStart, int arrayCount) {
            this.typeString = typeString;
            this.arrayStart = arrayStart;
            this.arrayCount = arrayCount;
        }

        public CastInfo(String typeString) {
            if (typeString == null) {
                throw new IllegalArgumentException();
            }
            this.typeString = typeString;
            this.arrayCount = 0;
            this.arrayStart = 0;
        }

        public CastInfo(int arrayStart, int arrayCount) {
            if (arrayCount <= 0) {
                throw new IllegalArgumentException();
            }
            this.typeString = null;
            this.arrayStart = arrayStart;
            this.arrayCount = arrayCount;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.arrayCount;
            result = 31 * result + this.arrayStart;
            result = 31 * result + (this.typeString == null ? 0 : this.typeString.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CastInfo other = (CastInfo)obj;
            if (this.arrayCount != other.arrayCount) {
                return false;
            }
            if (this.arrayStart != other.arrayStart) {
                return false;
            }
            return !(this.typeString == null ? other.typeString != null : !this.typeString.equals(other.typeString));
        }

        public String getTypeString() {
            return this.typeString;
        }

        public int getArrayStartIndex() {
            return this.arrayStart;
        }

        public int getArrayCount() {
            return this.arrayCount;
        }
    }

    public static interface ICastedExpressionDMContext
    extends IExpressions.IExpressionDMContext {
        public CastInfo getCastInfo();
    }
}

