/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.ext;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.ext.CElementHandle;

public class FunctionDeclarationHandle
extends CElementHandle
implements IFunctionDeclaration {
    private String[] fParameterTypes;
    private String fReturnType;
    private boolean fIsStatic;

    public FunctionDeclarationHandle(ICElement parent, IFunction func) {
        this(parent, 73, func);
    }

    protected FunctionDeclarationHandle(ICElement parent, int type, IFunction func) {
        super(parent, type, func.getName());
        this.fParameterTypes = this.extractParameterTypes(func);
        this.fReturnType = ASTTypeUtil.getType(func.getType().getReturnType(), false);
        this.fIsStatic = func.isStatic();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IFunctionDeclaration) {
            return FunctionDeclaration.equals(this, (IFunctionDeclaration)obj);
        }
        return false;
    }

    @Override
    public int getNumberOfParameters() {
        return this.fParameterTypes.length;
    }

    @Override
    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    @Override
    public String getReturnType() {
        return this.fReturnType;
    }

    @Override
    public String getSignature() throws CModelException {
        return FunctionDeclaration.getSignature(this);
    }

    @Override
    public boolean isStatic() throws CModelException {
        return this.fIsStatic;
    }
}

