/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataSerializer;
import org.eclipse.cdt.core.settings.model.util.EntryStore;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.core.settings.model.util.UserAndDiscoveredEntryLanguageData;

public class UserAndDiscoveredEntryDataSerializer
extends CDataSerializer {
    protected static final String DISABLED_DISCOVERED_ENTRIES = "disabledDiscoveredEntries";
    protected static final String KIND = "kind";
    protected static final String VALUE = "value";
    private static UserAndDiscoveredEntryDataSerializer fInstance;

    public static CDataSerializer getDefault() {
        if (fInstance == null) {
            fInstance = new UserAndDiscoveredEntryDataSerializer();
        }
        return fInstance;
    }

    @Override
    public void loadEntries(CLanguageData data, ICStorageElement el) {
        ICStorageElement[] children;
        int[] kinds;
        UserAndDiscoveredEntryLanguageData lData = (UserAndDiscoveredEntryLanguageData)data;
        List<ICSettingEntry> entries = LanguageSettingEntriesSerializer.loadEntriesList(el);
        EntryStore store = new EntryStore();
        store.addEntries(entries.toArray(new ICLanguageSettingEntry[entries.size()]));
        int[] nArray = kinds = KindBasedStore.getLanguageEntryKinds();
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            int kind = nArray[n2];
            if (store.containsEntriesList(kind)) {
                ICLanguageSettingEntry[] sortedEntries = store.getEntries(kind);
                lData.setEntriesToStore(kind, sortedEntries);
            }
            ++n2;
        }
        ICStorageElement[] iCStorageElementArray = children = el.getChildren();
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            ICStorageElement child = iCStorageElementArray[n];
            String name = child.getName();
            if (DISABLED_DISCOVERED_ENTRIES.equals(name)) {
                this.loadDisabledEntriesInfo(lData, child);
            }
            ++n;
        }
    }

    protected void loadDisabledEntriesInfo(UserAndDiscoveredEntryLanguageData lData, ICStorageElement el) {
        ICStorageElement[] children;
        ICStorageElement[] iCStorageElementArray = children = el.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp;
            int kind;
            ICStorageElement child = iCStorageElementArray[n2];
            String name = child.getName();
            if ("name".equals(name) && (kind = LanguageSettingEntriesSerializer.stringToKind(tmp = child.getAttribute(KIND))) != 0 && (tmp = child.getAttribute(VALUE)) != null) {
                Set<String> set = lData.getDisabledSet(kind);
                if (set == null) {
                    set = new HashSet<String>();
                }
                set.add(tmp);
                lData.setDisabledSet(kind, set);
            }
            ++n2;
        }
    }

    @Override
    public void storeEntries(CLanguageData data, ICStorageElement el) {
        int[] kinds;
        UserAndDiscoveredEntryLanguageData lData = (UserAndDiscoveredEntryLanguageData)data;
        int[] nArray = kinds = KindBasedStore.getLanguageEntryKinds();
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            int kind = nArray[n2];
            ICSettingEntry[] sortedEntries = lData.getEntriesFromStore(kind);
            if (sortedEntries != null && sortedEntries.length != 0) {
                LanguageSettingEntriesSerializer.serializeEntries(sortedEntries, el);
            }
            ++n2;
        }
        ICStorageElement disabledNamesEl = el.createChild(DISABLED_DISCOVERED_ENTRIES);
        this.storeDisabledEntriesInfo(lData, disabledNamesEl);
    }

    protected void storeDisabledEntriesInfo(UserAndDiscoveredEntryLanguageData lData, ICStorageElement el) {
        int[] kinds;
        int[] nArray = kinds = KindBasedStore.getLanguageEntryKinds();
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            int kind = nArray[n2];
            Set<String> set = lData.getDisabledSet(kind);
            if (set != null && set.size() != 0) {
                for (String string : set) {
                    ICStorageElement child = el.createChild("name");
                    child.setAttribute(KIND, LanguageSettingEntriesSerializer.kindToString(kind));
                    child.setAttribute(VALUE, string);
                }
            }
            ++n2;
        }
    }
}

