/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.eef.properties.ui.api.EEFTabContents;
import org.eclipse.eef.properties.ui.api.IEEFSection;
import org.eclipse.eef.properties.ui.api.IEEFSectionDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.internal.EEFTabbedPropertyViewPlugin;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractEEFTabDescriptor
implements IEEFTabDescriptor,
Cloneable {
    private List<IEEFSectionDescriptor> sectionDescriptors = new ArrayList<IEEFSectionDescriptor>();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            EEFTabbedPropertyViewPlugin.getPlugin().error(exception.getMessage(), exception);
            return null;
        }
    }

    @Override
    public EEFTabContents createTab() {
        ArrayList<IEEFSection> sections = new ArrayList<IEEFSection>(this.getSectionDescriptors().size());
        for (IEEFSectionDescriptor sectionDescriptor : this.sectionDescriptors) {
            IEEFSection section = sectionDescriptor.getSectionClass();
            if (section == null) continue;
            sections.add(section);
        }
        EEFTabContents tab = new EEFTabContents(sections);
        return tab;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean isEqual = false;
        if (this.getClass() == object.getClass()) {
            AbstractEEFTabDescriptor descriptor = (AbstractEEFTabDescriptor)object;
            if (this.getCategory().equals(descriptor.getCategory()) && this.getId().equals(descriptor.getId()) && this.getSectionDescriptors().size() == descriptor.getSectionDescriptors().size()) {
                Iterator<IEEFSectionDescriptor> i = this.getSectionDescriptors().iterator();
                Iterator<IEEFSectionDescriptor> j = descriptor.getSectionDescriptors().iterator();
                while (i.hasNext()) {
                    IEEFSectionDescriptor source = i.next();
                    IEEFSectionDescriptor target = j.next();
                    if (source.getId().equals(target.getId())) continue;
                    isEqual = false;
                }
                isEqual = true;
            }
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = this.getCategory().hashCode();
        hashCode ^= this.getId().hashCode();
        for (IEEFSectionDescriptor sectionDescriptor : this.sectionDescriptors) {
            hashCode ^= sectionDescriptor.getId().hashCode();
        }
        return hashCode;
    }

    @Override
    public String getAfterTab() {
        return "top";
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public List<IEEFSectionDescriptor> getSectionDescriptors() {
        return this.sectionDescriptors;
    }

    @Override
    public String getText() {
        return this.getLabel();
    }

    @Override
    public boolean isIndented() {
        return false;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    public void setSectionDescriptors(List<IEEFSectionDescriptor> sectionDescriptors) {
        this.sectionDescriptors = sectionDescriptors;
    }
}

