/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.description.style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Side implements Enumerator
{
    WEST(0, "WEST", "WEST"),
    SOUTH(1, "SOUTH", "SOUTH"),
    EAST(2, "EAST", "EAST"),
    NORTH(3, "NORTH", "NORTH");

    public static final int WEST_VALUE = 0;
    public static final int SOUTH_VALUE = 1;
    public static final int EAST_VALUE = 2;
    public static final int NORTH_VALUE = 3;
    private static final Side[] VALUES_ARRAY;
    public static final List<Side> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Side[]{WEST, SOUTH, EAST, NORTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Side get(String literal) {
        Side[] sideArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            Side result = sideArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static Side getByName(String name) {
        Side[] sideArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            Side result = sideArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static Side get(int value) {
        switch (value) {
            case 0: {
                return WEST;
            }
            case 1: {
                return SOUTH;
            }
            case 2: {
                return EAST;
            }
            case 3: {
                return NORTH;
            }
        }
        return null;
    }

    private Side(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

