/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.rmf;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rmf.reqif10.SpecType;
import org.polarsys.reqcycle.repository.connector.ICallable;
import org.polarsys.reqcycle.repository.connector.IURIValidatorConnector;
import org.polarsys.reqcycle.repository.connector.rmf.RMFCallable;
import org.polarsys.reqcycle.repository.connector.rmf.RMFUtils;
import org.polarsys.reqcycle.repository.connector.rmf.ui.RMFBean;
import org.polarsys.reqcycle.repository.connector.rmf.ui.RMFRepositoryMappingPage;
import org.polarsys.reqcycle.repository.connector.rmf.ui.RMFSettingPage;
import org.polarsys.reqcycle.repository.connector.ui.wizard.IConnectorWizard;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class RMFConnector
extends Wizard
implements IConnectorWizard,
IURIValidatorConnector {
    protected RMFRepositoryMappingPage mappingPage;
    protected RMFSettingPage settingPage;
    protected RequirementSource initSource;
    protected RMFBean bean;
    private String lastURI = null;
    @Inject
    IDataModelManager dataTypeManage;
    @Inject
    IDataManager dataManager;
    protected URI initFileUri;

    public ICallable getRequirementsCreator() {
        RMFCallable callable = (RMFCallable)ZigguratInject.make(RMFCallable.class);
        return callable;
    }

    public void addPages() {
        this.bean = new RMFBean();
        this.settingPage = new RMFSettingPage(this.bean);
        this.addPage((IWizardPage)this.settingPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof RMFSettingPage) {
            ResourceSetImpl rs = new ResourceSetImpl();
            if (!(this.bean.getUri() == null || this.bean.getUri().equals("") || this.mappingPage != null && this.bean.getUri().equals(this.lastURI))) {
                this.lastURI = this.bean.getUri();
                Collection<SpecType> specTypes = RMFUtils.getReqIFTypes((ResourceSet)rs, this.bean.getUri());
                if (this.bean.getDataModel() != null) {
                    Collection eClassifiers = this.bean.getDataModel().getTypes();
                    this.mappingPage = this.createMappingPage(specTypes, eClassifiers);
                    this.mappingPage.setWizard((IWizard)this);
                }
            }
            return this.mappingPage;
        }
        return super.getNextPage(page);
    }

    private RMFRepositoryMappingPage createMappingPage(final Collection<SpecType> specTypes, final Collection<IType> eClassifiers) {
        return new RMFRepositoryMappingPage("ReqIF Mapping", ""){

            @Override
            protected Object getTargetInput() {
                return eClassifiers;
            }

            @Override
            protected String getTargetDetail() {
                return "ReqCycle";
            }

            @Override
            protected IBaseLabelProvider getSourceLabelProvider() {
                return new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof SpecType) {
                            SpecType st = (SpecType)element;
                            String label = "<no name>";
                            if (st.getLongName() != null) {
                                label = st.getLongName();
                            }
                            return label;
                        }
                        return super.getText(element);
                    }
                };
            }

            @Override
            protected Object getSourceInput() {
                return specTypes;
            }

            @Override
            protected String getSourceDetail() {
                return "ReqIF";
            }

            @Override
            protected IContentProvider getSourceContentProvider() {
                return RMFUtils.contentProvider;
            }

            @Override
            protected String getResultDetail() {
                return null;
            }

            @Override
            protected Collection<EObject> addToMapping() {
                return null;
            }
        };
    }

    public void initializeWithRequirementSource(RequirementSource requirementSource) {
        this.initSource = requirementSource;
    }

    public void init(ISelection selection, String name) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.initFileUri = URI.createPlatformResourceURI((String)((IFile)obj).getFullPath().toPortableString(), (boolean)true);
        }
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        if (this.settingPage != null && this.settingPage.isPageComplete() && this.bean != null && this.mappingPage != null && this.mappingPage.isPageComplete()) {
            return true;
        }
        if (this.initSource != null) {
            return this.mappingPage != null && this.mappingPage.isPageComplete();
        }
        return false;
    }

    public void storeProperties(RequirementSource source) {
        this.bean.storeProperties(source);
        if (this.mappingPage != null && this.mappingPage.getResult() != null) {
            ArrayList<MappingElement> mapElements = new ArrayList<MappingElement>();
            for (EObject eo : this.mappingPage.getResult()) {
                mapElements.add((MappingElement)eo);
            }
            source.getMappings().addAll(mapElements);
        }
    }

    public IStatus validate(URI uri) {
        String EXTENSIONS = "reqif";
        String extension = uri.path().substring(uri.path().lastIndexOf(".") + 1, uri.path().length());
        if (EXTENSIONS.contains(extension.toLowerCase())) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.polarsys.reqcycle.repository.connector.rmf", "extension \"" + extension + "\" could not be supported");
    }
}

