/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.set.strategy;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.set.AbstractMutableSetMultimap;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.utility.Iterate;

public final class UnifiedSetWithHashingStrategyMultimap<K, V>
extends AbstractMutableSetMultimap<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private HashingStrategy<? super V> hashingStrategy;

    @Deprecated
    public UnifiedSetWithHashingStrategyMultimap() {
    }

    public UnifiedSetWithHashingStrategyMultimap(HashingStrategy<? super V> hashingStrategy) {
        this.hashingStrategy = hashingStrategy;
    }

    public UnifiedSetWithHashingStrategyMultimap(UnifiedSetWithHashingStrategyMultimap<K, V> multimap) {
        this(multimap.hashingStrategy, multimap);
    }

    public UnifiedSetWithHashingStrategyMultimap(HashingStrategy<? super V> hashingStrategy, Multimap<? extends K, ? extends V> multimap) {
        super(Math.max(multimap.sizeDistinct() * 2, 16));
        this.hashingStrategy = hashingStrategy;
        this.putAll(multimap);
    }

    public UnifiedSetWithHashingStrategyMultimap(HashingStrategy<? super V> hashingStrategy, Pair<K, V> ... pairs) {
        this.hashingStrategy = hashingStrategy;
        this.putAllPairs(pairs);
    }

    public UnifiedSetWithHashingStrategyMultimap(HashingStrategy<? super V> hashingStrategy, Iterable<Pair<K, V>> inputIterable) {
        this.hashingStrategy = hashingStrategy;
        for (Pair<K, V> single : inputIterable) {
            this.add(single);
        }
    }

    public static <K, V> UnifiedSetWithHashingStrategyMultimap<K, V> newMultimap(UnifiedSetWithHashingStrategyMultimap<K, V> multimap) {
        return new UnifiedSetWithHashingStrategyMultimap<K, V>(multimap);
    }

    public static <K, V> UnifiedSetWithHashingStrategyMultimap<K, V> newMultimap(HashingStrategy<? super V> hashingStrategy, Multimap<? extends K, ? extends V> multimap) {
        return new UnifiedSetWithHashingStrategyMultimap<K, V>(hashingStrategy, multimap);
    }

    public static <K, V> UnifiedSetWithHashingStrategyMultimap<K, V> newMultimap(HashingStrategy<? super V> hashingStrategy) {
        return new UnifiedSetWithHashingStrategyMultimap<K, V>(hashingStrategy);
    }

    public static <K, V> UnifiedSetWithHashingStrategyMultimap<K, V> newMultimap(HashingStrategy<? super V> hashingStrategy, Pair<K, V> ... pairs) {
        return new UnifiedSetWithHashingStrategyMultimap<K, V>(hashingStrategy, pairs);
    }

    public static <K, V> UnifiedSetWithHashingStrategyMultimap<K, V> newMultimap(HashingStrategy<? super V> hashingStrategy, Iterable<Pair<K, V>> inputIterable) {
        return new UnifiedSetWithHashingStrategyMultimap<K, V>(hashingStrategy, inputIterable);
    }

    @Override
    protected MutableMap<K, MutableSet<V>> createMap() {
        return UnifiedMap.newMap();
    }

    @Override
    protected MutableMap<K, MutableSet<V>> createMapWithKeyCount(int keyCount) {
        return UnifiedMap.newMap(keyCount);
    }

    @Override
    protected UnifiedSetWithHashingStrategy<V> createCollection() {
        return UnifiedSetWithHashingStrategy.newSet(this.hashingStrategy);
    }

    public UnifiedSetWithHashingStrategyMultimap<K, V> newEmpty() {
        return new UnifiedSetWithHashingStrategyMultimap<K, V>(this.hashingStrategy);
    }

    public HashingStrategy<? super V> getValueHashingStrategy() {
        return this.hashingStrategy;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashingStrategy = (HashingStrategy)in.readObject();
        super.readExternal(in);
    }

    public MutableSetMultimap<V, K> flip() {
        return Iterate.flip(this);
    }

    public UnifiedSetWithHashingStrategyMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (UnifiedSetWithHashingStrategyMultimap)this.selectKeysValues(predicate, this.newEmpty());
    }

    public UnifiedSetWithHashingStrategyMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return (UnifiedSetWithHashingStrategyMultimap)this.rejectKeysValues(predicate, this.newEmpty());
    }

    public UnifiedSetWithHashingStrategyMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return (UnifiedSetWithHashingStrategyMultimap)this.selectKeysMultiValues(predicate, this.newEmpty());
    }

    public UnifiedSetWithHashingStrategyMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return (UnifiedSetWithHashingStrategyMultimap)this.rejectKeysMultiValues(predicate, this.newEmpty());
    }
}

