/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;

public class RegexValueEvaluationStepSupplier {
    public static QueryValueEvaluationStep make(EvaluationStrategy strategy, Regex node, QueryEvaluationContext context) {
        QueryValueEvaluationStep argStep = strategy.precompile(node.getArg(), context);
        QueryValueEvaluationStep pargStep = strategy.precompile(node.getPatternArg(), context);
        QueryValueEvaluationStep fargStep = null;
        ValueExpr flagsArg = node.getFlagsArg();
        if (flagsArg != null) {
            fargStep = strategy.precompile(flagsArg, context);
        }
        if (argStep.isConstant() && pargStep.isConstant() && (flagsArg == null || fargStep.isConstant())) {
            return RegexValueEvaluationStepSupplier.allRegexPartsAreConstant(argStep, pargStep, fargStep, flagsArg);
        }
        if (pargStep.isConstant() && (flagsArg == null || fargStep.isConstant())) {
            return RegexValueEvaluationStepSupplier.regexAndFlagsAreConstant(argStep, pargStep, fargStep, flagsArg);
        }
        return new ChangingRegexQueryValueEvaluationStep(node, strategy);
    }

    private static QueryValueEvaluationStep regexAndFlagsAreConstant(QueryValueEvaluationStep argStep, QueryValueEvaluationStep pargStep, QueryValueEvaluationStep fargStep, ValueExpr flagsArg) {
        Value parg = pargStep.evaluate(EmptyBindingSet.getInstance());
        Value farg = null;
        if (flagsArg != null) {
            farg = fargStep.evaluate(EmptyBindingSet.getInstance());
        }
        if (QueryEvaluationUtility.isSimpleLiteral(parg) && (farg == null || QueryEvaluationUtility.isSimpleLiteral(farg))) {
            String ptn = ((Literal)parg).getLabel();
            int f = RegexValueEvaluationStepSupplier.extractRegexFlags(farg);
            Pattern pattern = Pattern.compile(ptn, f);
            return bindings -> {
                Value arg = argStep.evaluate(bindings);
                if (QueryEvaluationUtility.isStringLiteral(arg)) {
                    String text = ((Literal)arg).getLabel();
                    boolean result = pattern.matcher(text).find();
                    return BooleanLiteral.valueOf(result);
                }
                throw new ValueExprEvaluationException();
            };
        }
        throw new ValueExprEvaluationException();
    }

    private static QueryValueEvaluationStep allRegexPartsAreConstant(QueryValueEvaluationStep argStep, QueryValueEvaluationStep pargStep, QueryValueEvaluationStep fargStep, ValueExpr flagsArg) {
        Value arg = argStep.evaluate(EmptyBindingSet.getInstance());
        Value parg = pargStep.evaluate(EmptyBindingSet.getInstance());
        Value farg = null;
        if (flagsArg != null) {
            farg = fargStep.evaluate(EmptyBindingSet.getInstance());
        }
        if (QueryEvaluationUtility.isStringLiteral(arg) && QueryEvaluationUtility.isSimpleLiteral(parg) && (farg == null || QueryEvaluationUtility.isSimpleLiteral(farg))) {
            String text = ((Literal)arg).getLabel();
            String ptn = ((Literal)parg).getLabel();
            int f = RegexValueEvaluationStepSupplier.extractRegexFlags(farg);
            Pattern pattern = Pattern.compile(ptn, f);
            boolean result = pattern.matcher(text).find();
            BooleanLiteral valueOf = BooleanLiteral.valueOf(result);
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(valueOf);
        }
        throw new ValueExprEvaluationException();
    }

    private static int extractRegexFlags(Value farg) {
        String flags = "";
        if (farg != null) {
            flags = ((Literal)farg).getLabel();
        }
        int f = 0;
        block9: for (char c : flags.toCharArray()) {
            switch (c) {
                case 's': {
                    f |= 0x20;
                    continue block9;
                }
                case 'm': {
                    f |= 8;
                    continue block9;
                }
                case 'i': {
                    f |= 2;
                    f |= 0x40;
                    continue block9;
                }
                case 'x': {
                    f |= 4;
                    continue block9;
                }
                case 'd': {
                    f |= 1;
                    continue block9;
                }
                case 'u': {
                    f |= 0x40;
                    continue block9;
                }
                case 'q': {
                    f |= 0x10;
                    continue block9;
                }
                default: {
                    throw new ValueExprEvaluationException(flags);
                }
            }
        }
        return f;
    }

    private static final class ChangingRegexQueryValueEvaluationStep
    implements QueryValueEvaluationStep {
        private final Regex node;
        private final EvaluationStrategy strategy;
        private Value parg;
        private Value farg;
        private Pattern pattern;

        private ChangingRegexQueryValueEvaluationStep(Regex node, EvaluationStrategy strategy) {
            this.node = node;
            this.strategy = strategy;
        }

        @Override
        public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
            Value arg = this.strategy.evaluate(this.node.getArg(), bindings);
            Value parg = this.strategy.evaluate(this.node.getPatternArg(), bindings);
            Value farg = null;
            ValueExpr flagsArg = this.node.getFlagsArg();
            if (flagsArg != null) {
                farg = this.strategy.evaluate(flagsArg, bindings);
            }
            if (QueryEvaluationUtility.isStringLiteral(arg) && QueryEvaluationUtility.isSimpleLiteral(parg) && (farg == null || QueryEvaluationUtility.isSimpleLiteral(farg))) {
                Pattern pattern = this.getPattern((Literal)parg, farg);
                String text = ((Literal)arg).getLabel();
                boolean result = pattern.matcher(text).find();
                return BooleanLiteral.valueOf(result);
            }
            throw new ValueExprEvaluationException();
        }

        private Pattern getPattern(Literal parg, Value farg) {
            if (this.parg == parg && this.farg == farg) {
                return this.pattern;
            }
            String ptn = parg.getLabel();
            int f = RegexValueEvaluationStepSupplier.extractRegexFlags(farg);
            Pattern pattern = Pattern.compile(ptn, f);
            this.parg = parg;
            this.farg = farg;
            this.pattern = pattern;
            return pattern;
        }
    }
}

