/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class ServiceNpsUnionFuser {
    private ServiceNpsUnionFuser() {
    }

    public static IrBGP fuse(IrBGP bgp) {
        if (bgp == null || bgp.getLines().isEmpty()) {
            return bgp;
        }
        if (bgp.getLines().size() == 1 && bgp.getLines().get(0) instanceof IrUnion) {
            IrNode fused = ServiceNpsUnionFuser.tryFuseUnion((IrUnion)bgp.getLines().get(0));
            if (fused instanceof IrPathTriple || fused instanceof IrGraph) {
                IrBGP nw = new IrBGP(bgp.isNewScope());
                nw.add(fused);
                return nw;
            }
            if (fused instanceof IrBGP) {
                return (IrBGP)fused;
            }
        }
        boolean replaced = false;
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (IrNode ln : bgp.getLines()) {
            if (ln instanceof IrUnion) {
                IrNode fused = ServiceNpsUnionFuser.tryFuseUnion((IrUnion)ln);
                if (fused instanceof IrPathTriple || fused instanceof IrGraph) {
                    out.add(fused);
                    replaced = true;
                    continue;
                }
                if (fused instanceof IrBGP) {
                    out.add(fused);
                    replaced = true;
                    continue;
                }
            }
            out.add(ln);
        }
        if (!replaced) {
            return bgp;
        }
        IrBGP nw = new IrBGP(bgp.isNewScope());
        out.forEach(nw::add);
        return nw;
    }

    private static IrNode tryFuseUnion(IrUnion u) {
        IrPathTriple fused;
        if (u == null || u.getBranches().size() != 2) {
            return u;
        }
        if (BaseTransform.unionIsExplicitAndAllBranchesScoped(u)) {
            return u;
        }
        Branch b1 = ServiceNpsUnionFuser.extractBranch(u.getBranches().get(0));
        Branch b2 = ServiceNpsUnionFuser.extractBranch(u.getBranches().get(1));
        if (b1 == null || b2 == null) {
            return u;
        }
        IrPathTriple p1 = b1.pt;
        IrPathTriple p2 = b2.pt;
        Var graphRef = b1.graph;
        if (graphRef == null && b2.graph != null || graphRef != null && b2.graph == null || graphRef != null && !ServiceNpsUnionFuser.eqVarOrValue(graphRef, b2.graph)) {
            return u;
        }
        Var sCanon = p1.getSubject();
        Var oCanon = p1.getObject();
        String m1 = BaseTransform.normalizeCompactNps(p1.getPathText());
        String m2 = BaseTransform.normalizeCompactNps(p2.getPathText());
        if (m1 == null || m2 == null) {
            return u;
        }
        String add2 = m2;
        if (ServiceNpsUnionFuser.eqVarOrValue(sCanon, p2.getObject()) && ServiceNpsUnionFuser.eqVarOrValue(oCanon, p2.getSubject())) {
            String inv = BaseTransform.invertNegatedPropertySet(m2);
            if (inv == null) {
                return u;
            }
            add2 = inv;
        } else if (!ServiceNpsUnionFuser.eqVarOrValue(sCanon, p2.getSubject()) || !ServiceNpsUnionFuser.eqVarOrValue(oCanon, p2.getObject())) {
            return u;
        }
        String merged = BaseTransform.mergeNpsMembers(m1, add2);
        HashSet<Var> pv = new HashSet<Var>();
        pv.addAll(p1.getPathVars());
        pv.addAll(p2.getPathVars());
        IrNode out = fused = new IrPathTriple(sCanon, p1.getSubjectOverride(), merged, oCanon, p1.getObjectOverride(), pv, u.isNewScope());
        if (graphRef != null) {
            IrBGP inner = new IrBGP(false);
            inner.add(fused);
            out = new IrGraph(graphRef, inner, false);
        }
        if (u.isNewScope()) {
            IrBGP grp = new IrBGP(false);
            grp.add(out);
            return grp;
        }
        return out;
    }

    private static Branch extractBranch(IrBGP b) {
        IrNode inner;
        Branch out = new Branch();
        if (b == null || b.getLines() == null || b.getLines().isEmpty()) {
            return null;
        }
        IrNode cur = ServiceNpsUnionFuser.singleChild(b);
        while (cur instanceof IrBGP && (inner = ServiceNpsUnionFuser.singleChild((IrBGP)cur)) != null) {
            cur = inner;
        }
        if (cur instanceof IrGraph) {
            IrNode inner2;
            IrGraph g = (IrGraph)cur;
            out.graph = g.getGraph();
            cur = ServiceNpsUnionFuser.singleChild(g.getWhere());
            while (cur instanceof IrBGP && (inner2 = ServiceNpsUnionFuser.singleChild((IrBGP)cur)) != null) {
                cur = inner2;
            }
        }
        if (cur instanceof IrPathTriple) {
            out.pt = (IrPathTriple)cur;
            return out;
        }
        return null;
    }

    private static IrNode singleChild(IrBGP b) {
        if (b == null) {
            return null;
        }
        List<IrNode> ls = b.getLines();
        if (ls == null || ls.size() != 1) {
            return null;
        }
        return ls.get(0);
    }

    private static boolean eqVarOrValue(Var a, Var b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.hasValue() && b.hasValue()) {
            return a.getValue().equals((Object)b.getValue());
        }
        if (!a.hasValue() && !b.hasValue()) {
            String an = a.getName();
            String bn = b.getName();
            return an != null && an.equals(bn);
        }
        return false;
    }

    private static final class Branch {
        Var graph;
        IrPathTriple pt;

        private Branch() {
        }
    }
}

