/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public final class IrInlineTriple
extends IrNode {
    private final Var subject;
    private final Var predicate;
    private final Var object;

    public IrInlineTriple(Var subject, Var predicate, Var object) {
        super(false);
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    @Override
    public void print(IrPrinter p) {
        p.append("<<");
        p.append(" " + p.convertVarToString(this.subject));
        p.append(" " + this.predicateText(p));
        p.append(" " + p.convertVarToString(this.object) + " >>");
    }

    private String predicateText(IrPrinter p) {
        if (this.predicate != null && this.predicate.hasValue() && this.predicate.getValue() instanceof IRI && RDF.TYPE.equals((Object)this.predicate.getValue())) {
            return "a";
        }
        return p.convertVarToString(this.predicate);
    }

    @Override
    public Set<Var> getVars() {
        HashSet<Var> out = new HashSet<Var>();
        if (this.subject != null) {
            out.add(this.subject);
        }
        if (this.predicate != null) {
            out.add(this.predicate);
        }
        if (this.object != null) {
            out.add(this.object);
        }
        return out;
    }
}

