/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class QueryEvaluationUtil {
    public static final ValueExprEvaluationException INDETERMINATE_DATE_TIME_EXCEPTION = new ValueExprEvaluationException("Indeterminate result for date/time comparison");
    public static final ValueExprEvaluationException STRING_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION = new ValueExprEvaluationException("Unable to compare strings with other supported types");
    public static final ValueExprEvaluationException NUMERIC_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION = new ValueExprEvaluationException("Unable to compare numeric types with other supported types");
    public static final ValueExprEvaluationException DATE_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION = new ValueExprEvaluationException("Unable to compare date types with other supported types");
    public static final ValueExprEvaluationException UNSUPPOERTED_TYPES_EXCEPTION = new ValueExprEvaluationException("Unable to compare literals with unsupported types");
    public static final ValueExprEvaluationException NOT_COMPATIBLE_AND_ORDERED_EXCEPTION = new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");

    public static boolean getEffectiveBooleanValue(Value value) throws ValueExprEvaluationException {
        if (value == BooleanLiteral.TRUE) {
            return true;
        }
        if (value == BooleanLiteral.FALSE) {
            return false;
        }
        if (value.isLiteral()) {
            Literal lit = (Literal)value;
            String label = lit.getLabel();
            CoreDatatype.XSD dt = lit.getCoreDatatype().asXSDDatatypeOrNull();
            if (dt == CoreDatatype.XSD.STRING) {
                return !label.isEmpty();
            }
            if (dt == CoreDatatype.XSD.BOOLEAN) {
                return "true".equals(label) || "1".equals(label);
            }
            try {
                if (dt == CoreDatatype.XSD.DECIMAL) {
                    return !"0.0".equals(XMLDatatypeUtil.normalizeDecimal((String)label));
                }
                if (dt != null && dt.isIntegerDatatype()) {
                    return !"0".equals(XMLDatatypeUtil.normalize((String)label, (CoreDatatype.XSD)dt));
                }
                if (dt != null && dt.isFloatingPointDatatype()) {
                    String n = XMLDatatypeUtil.normalize((String)label, (CoreDatatype.XSD)dt);
                    return !"0.0E0".equals(n) && !"NaN".equals(n);
                }
            }
            catch (IllegalArgumentException ignore) {
                return false;
            }
        }
        throw new ValueExprEvaluationException();
    }

    private static boolean _lt(int c) {
        return c < 0;
    }

    private static boolean _le(int c) {
        return c <= 0;
    }

    private static boolean _eq(int c) {
        return c == 0;
    }

    private static boolean _ne(int c) {
        return c != 0;
    }

    private static boolean _gt(int c) {
        return c > 0;
    }

    private static boolean _ge(int c) {
        return c >= 0;
    }

    public static boolean compareEQ(Value l, Value r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareEQ(l, r, true);
    }

    public static boolean compareEQ(Value l, Value r, boolean strict) throws ValueExprEvaluationException {
        if (l == null || r == null) {
            return l == r;
        }
        if (l == r) {
            return true;
        }
        if (l.isLiteral() && r.isLiteral()) {
            return QueryEvaluationUtil.doCompareLiteralsEQ((Literal)l, (Literal)r, strict);
        }
        return l.equals((Object)r);
    }

    public static boolean compareNE(Value l, Value r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareNE(l, r, true);
    }

    public static boolean compareNE(Value l, Value r, boolean strict) throws ValueExprEvaluationException {
        if (l == null || r == null) {
            return l != r;
        }
        if (l == r) {
            return false;
        }
        if (l.isLiteral() && r.isLiteral()) {
            return QueryEvaluationUtil.doCompareLiteralsNE((Literal)l, (Literal)r, strict);
        }
        return !l.equals((Object)r);
    }

    public static boolean compareLT(Value l, Value r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLT(l, r, true);
    }

    public static boolean compareLT(Value l, Value r, boolean strict) throws ValueExprEvaluationException {
        if (l == r) {
            if (l == null || !l.isLiteral()) {
                throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
            }
            return false;
        }
        if (l != null && l.isLiteral() && r != null && r.isLiteral()) {
            return QueryEvaluationUtil.doCompareLiteralsLT((Literal)l, (Literal)r, strict);
        }
        throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
    }

    public static boolean compareLE(Value l, Value r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLE(l, r, true);
    }

    public static boolean compareLE(Value l, Value r, boolean strict) throws ValueExprEvaluationException {
        if (l == r) {
            if (l == null || !l.isLiteral()) {
                throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
            }
            return true;
        }
        if (l != null && l.isLiteral() && r != null && r.isLiteral()) {
            return QueryEvaluationUtil.doCompareLiteralsLE((Literal)l, (Literal)r, strict);
        }
        throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
    }

    public static boolean compareGT(Value l, Value r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareGT(l, r, true);
    }

    public static boolean compareGT(Value l, Value r, boolean strict) throws ValueExprEvaluationException {
        if (l == r) {
            if (l == null || !l.isLiteral()) {
                throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
            }
            return false;
        }
        if (l != null && l.isLiteral() && r != null && r.isLiteral()) {
            return QueryEvaluationUtil.doCompareLiteralsGT((Literal)l, (Literal)r, strict);
        }
        throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
    }

    public static boolean compareGE(Value l, Value r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareGE(l, r, true);
    }

    public static boolean compareGE(Value l, Value r, boolean strict) throws ValueExprEvaluationException {
        if (l == r) {
            if (l == null || !l.isLiteral()) {
                throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
            }
            return true;
        }
        if (l != null && l.isLiteral() && r != null && r.isLiteral()) {
            return QueryEvaluationUtil.doCompareLiteralsGE((Literal)l, (Literal)r, strict);
        }
        throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
    }

    public static boolean compareLiteralsEQ(Literal l, Literal r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiteralsEQ(l, r, true);
    }

    public static boolean compareLiteralsEQ(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.doCompareLiteralsEQ(l, r, strict);
    }

    public static boolean compareLiteralsNE(Literal l, Literal r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiteralsNE(l, r, true);
    }

    public static boolean compareLiteralsNE(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.doCompareLiteralsNE(l, r, strict);
    }

    public static boolean compareLiteralsLT(Literal l, Literal r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiteralsLT(l, r, true);
    }

    public static boolean compareLiteralsLT(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.doCompareLiteralsLT(l, r, strict);
    }

    public static boolean compareLiteralsLE(Literal l, Literal r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiteralsLE(l, r, true);
    }

    public static boolean compareLiteralsLE(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.doCompareLiteralsLE(l, r, strict);
    }

    public static boolean compareLiteralsGT(Literal l, Literal r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiteralsGT(l, r, true);
    }

    public static boolean compareLiteralsGT(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.doCompareLiteralsGT(l, r, strict);
    }

    public static boolean compareLiteralsGE(Literal l, Literal r) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiteralsGE(l, r, true);
    }

    public static boolean compareLiteralsGE(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.doCompareLiteralsGE(l, r, strict);
    }

    @Deprecated
    public static boolean compare(Value l, Value r, Compare.CompareOp op) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compare(l, r, op, true);
    }

    @Deprecated
    public static boolean compare(Value l, Value r, Compare.CompareOp op, boolean strict) throws ValueExprEvaluationException {
        switch (op) {
            case EQ: {
                return QueryEvaluationUtil.compareEQ(l, r, strict);
            }
            case NE: {
                return QueryEvaluationUtil.compareNE(l, r, strict);
            }
            case LT: {
                return QueryEvaluationUtil.compareLT(l, r, strict);
            }
            case LE: {
                return QueryEvaluationUtil.compareLE(l, r, strict);
            }
            case GT: {
                return QueryEvaluationUtil.compareGT(l, r, strict);
            }
            case GE: {
                return QueryEvaluationUtil.compareGE(l, r, strict);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf(op));
    }

    @Deprecated
    public static boolean compareLiterals(Literal l, Literal r, Compare.CompareOp op) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiterals(l, r, op, true);
    }

    @Deprecated
    public static boolean compareLiterals(Literal l, Literal r, Compare.CompareOp op, boolean strict) throws ValueExprEvaluationException {
        switch (op) {
            case EQ: {
                return QueryEvaluationUtil.compareLiteralsEQ(l, r, strict);
            }
            case NE: {
                return QueryEvaluationUtil.compareLiteralsNE(l, r, strict);
            }
            case LT: {
                return QueryEvaluationUtil.compareLiteralsLT(l, r, strict);
            }
            case LE: {
                return QueryEvaluationUtil.compareLiteralsLE(l, r, strict);
            }
            case GT: {
                return QueryEvaluationUtil.compareLiteralsGT(l, r, strict);
            }
            case GE: {
                return QueryEvaluationUtil.compareLiteralsGE(l, r, strict);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf(op));
    }

    public static boolean compareWithOperator(Compare.CompareOp op, int c) {
        switch (op) {
            case LT: {
                return QueryEvaluationUtil._lt(c);
            }
            case LE: {
                return QueryEvaluationUtil._le(c);
            }
            case EQ: {
                return QueryEvaluationUtil._eq(c);
            }
            case NE: {
                return QueryEvaluationUtil._ne(c);
            }
            case GE: {
                return QueryEvaluationUtil._ge(c);
            }
            case GT: {
                return QueryEvaluationUtil._gt(c);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf(op));
    }

    private static boolean doCompareLiteralsEQ(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        CoreDatatype.XSD common;
        CoreDatatype rd;
        if (l == r) {
            return true;
        }
        CoreDatatype ld = l.getCoreDatatype();
        if (ld == (rd = r.getCoreDatatype())) {
            if (ld == CoreDatatype.XSD.STRING) {
                return l.getLabel().equals(r.getLabel());
            }
            if (ld == CoreDatatype.RDF.LANGSTRING) {
                return l.getLanguage().equals(r.getLanguage()) && l.getLabel().equals(r.getLabel());
            }
        }
        boolean lLang = Literals.isLanguageLiteral((Literal)l);
        boolean rLang = Literals.isLanguageLiteral((Literal)r);
        if (!lLang && !rLang && (common = QueryEvaluationUtil.getCommonDatatype(strict, ld.asXSDDatatypeOrNull(), rd.asXSDDatatypeOrNull())) != null) {
            try {
                if (common == CoreDatatype.XSD.STRING) {
                    return l.getLabel().equals(r.getLabel());
                }
                if (common == CoreDatatype.XSD.DOUBLE) {
                    return l.doubleValue() == r.doubleValue();
                }
                if (common == CoreDatatype.XSD.FLOAT) {
                    return l.floatValue() == r.floatValue();
                }
                if (common == CoreDatatype.XSD.BOOLEAN) {
                    return l.booleanValue() == r.booleanValue();
                }
                if (l.getLabel().equals(r.getLabel())) {
                    return true;
                }
                if (common == CoreDatatype.XSD.DECIMAL) {
                    return l.decimalValue().compareTo(r.decimalValue()) == 0;
                }
                if (common.isIntegerDatatype()) {
                    return l.integerValue().compareTo(r.integerValue()) == 0;
                }
                if (common.isCalendarDatatype()) {
                    if (ld == rd && l.getLabel().equals(r.getLabel())) {
                        return true;
                    }
                    int c = l.calendarValue().compare(r.calendarValue());
                    if (c == 2 && ld == CoreDatatype.XSD.DATETIME && rd == CoreDatatype.XSD.DATETIME) {
                        throw INDETERMINATE_DATE_TIME_EXCEPTION;
                    }
                    return QueryEvaluationUtil._eq(c);
                }
                if (!strict && common.isDurationDatatype()) {
                    if (ld == rd && l.getLabel().equals(r.getLabel())) {
                        return true;
                    }
                    int c = XMLDatatypeUtil.parseDuration((String)l.getLabel()).compare(XMLDatatypeUtil.parseDuration((String)r.getLabel()));
                    if (c != 2) {
                        return QueryEvaluationUtil._eq(c);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return QueryEvaluationUtil.otherCasesEQ(l, r, ld.asXSDDatatypeOrNull(), rd.asXSDDatatypeOrNull(), lLang, rLang, strict);
    }

    private static boolean doCompareLiteralsNE(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        if (l.equals((Object)r)) {
            return false;
        }
        return !QueryEvaluationUtil.doCompareLiteralsEQ(l, r, strict);
    }

    private static boolean doCompareLiteralsLT(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        CoreDatatype.XSD common;
        CoreDatatype.XSD ld = l.getCoreDatatype().asXSDDatatypeOrNull();
        CoreDatatype.XSD rd = r.getCoreDatatype().asXSDDatatypeOrNull();
        boolean lLang = Literals.isLanguageLiteral((Literal)l);
        boolean rLang = Literals.isLanguageLiteral((Literal)r);
        if (QueryEvaluationUtil.isSimpleLiteral(lLang, (CoreDatatype)ld) && QueryEvaluationUtil.isSimpleLiteral(rLang, (CoreDatatype)rd)) {
            return QueryEvaluationUtil._lt(l.getLabel().compareTo(r.getLabel()));
        }
        if (!lLang && !rLang && (common = QueryEvaluationUtil.getCommonDatatype(strict, ld, rd)) != null) {
            try {
                int c;
                if (common == CoreDatatype.XSD.DOUBLE) {
                    return QueryEvaluationUtil._lt(Double.compare(l.doubleValue(), r.doubleValue()));
                }
                if (common == CoreDatatype.XSD.FLOAT) {
                    return QueryEvaluationUtil._lt(Float.compare(l.floatValue(), r.floatValue()));
                }
                if (common == CoreDatatype.XSD.DECIMAL) {
                    return QueryEvaluationUtil._lt(l.decimalValue().compareTo(r.decimalValue()));
                }
                if (common.isIntegerDatatype()) {
                    return QueryEvaluationUtil._lt(l.integerValue().compareTo(r.integerValue()));
                }
                if (common == CoreDatatype.XSD.BOOLEAN) {
                    return QueryEvaluationUtil._lt(Boolean.compare(l.booleanValue(), r.booleanValue()));
                }
                if (common.isCalendarDatatype()) {
                    int c2 = l.calendarValue().compare(r.calendarValue());
                    if (c2 == 2 && ld == CoreDatatype.XSD.DATETIME && rd == CoreDatatype.XSD.DATETIME) {
                        throw INDETERMINATE_DATE_TIME_EXCEPTION;
                    }
                    return QueryEvaluationUtil._lt(c2);
                }
                if (!strict && common.isDurationDatatype() && (c = XMLDatatypeUtil.parseDuration((String)l.getLabel()).compare(XMLDatatypeUtil.parseDuration((String)r.getLabel()))) != 2) {
                    return QueryEvaluationUtil._lt(c);
                }
                if (common == CoreDatatype.XSD.STRING) {
                    return QueryEvaluationUtil._lt(l.getLabel().compareTo(r.getLabel()));
                }
            }
            catch (IllegalArgumentException iae) {
                throw new ValueExprEvaluationException(iae);
            }
        }
        if (!QueryEvaluationUtil.isSupportedDatatype(ld) || !QueryEvaluationUtil.isSupportedDatatype(rd)) {
            throw UNSUPPOERTED_TYPES_EXCEPTION;
        }
        QueryEvaluationUtil.validateDatatypeCompatibility(strict, ld, rd);
        throw NOT_COMPATIBLE_AND_ORDERED_EXCEPTION;
    }

    private static boolean doCompareLiteralsLE(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.doCompareLiteralsLT(l, r, strict) || QueryEvaluationUtil.doCompareLiteralsEQ(l, r, strict);
    }

    private static boolean doCompareLiteralsGT(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return !QueryEvaluationUtil.doCompareLiteralsLE(l, r, strict);
    }

    private static boolean doCompareLiteralsGE(Literal l, Literal r, boolean strict) throws ValueExprEvaluationException {
        return !QueryEvaluationUtil.doCompareLiteralsLT(l, r, strict);
    }

    private static boolean otherCasesEQ(Literal left, Literal right, CoreDatatype.XSD ldt, CoreDatatype.XSD rdt, boolean lLang, boolean rLang, boolean strict) throws ValueExprEvaluationException {
        boolean equal = left.equals((Object)right);
        if (!equal) {
            if (!lLang && !rLang && QueryEvaluationUtil.isSupportedDatatype(ldt) && QueryEvaluationUtil.isSupportedDatatype(rdt)) {
                if (!XMLDatatypeUtil.isValidValue((String)left.getLabel(), (CoreDatatype.XSD)ldt)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + String.valueOf(left));
                }
                if (!XMLDatatypeUtil.isValidValue((String)right.getLabel(), (CoreDatatype.XSD)rdt)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + String.valueOf(right));
                }
                QueryEvaluationUtil.validateDatatypeCompatibility(strict, ldt, rdt);
            } else if (!lLang && !rLang) {
                throw UNSUPPOERTED_TYPES_EXCEPTION;
            }
        }
        return equal;
    }

    private static void validateDatatypeCompatibility(boolean strict, CoreDatatype.XSD ld, CoreDatatype.XSD rd) throws ValueExprEvaluationException {
        boolean rightDate;
        boolean rightNum;
        boolean rightString;
        if (!strict) {
            return;
        }
        boolean leftString = ld == CoreDatatype.XSD.STRING;
        boolean bl = rightString = rd == CoreDatatype.XSD.STRING;
        if (leftString != rightString) {
            throw STRING_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION;
        }
        boolean leftNum = ld.isNumericDatatype();
        if (leftNum != (rightNum = rd.isNumericDatatype())) {
            throw NUMERIC_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION;
        }
        boolean leftDate = ld.isCalendarDatatype();
        if (leftDate != (rightDate = rd.isCalendarDatatype())) {
            throw DATE_WITH_OTHER_SUPPORTED_TYPE_EXCEPTION;
        }
    }

    private static CoreDatatype.XSD getCommonDatatype(boolean strict, CoreDatatype.XSD ld, CoreDatatype.XSD rd) {
        if (ld != null && rd != null) {
            if (ld == rd) {
                return ld;
            }
            if (ld.isNumericDatatype() && rd.isNumericDatatype()) {
                if (ld == CoreDatatype.XSD.DOUBLE || rd == CoreDatatype.XSD.DOUBLE) {
                    return CoreDatatype.XSD.DOUBLE;
                }
                if (ld == CoreDatatype.XSD.FLOAT || rd == CoreDatatype.XSD.FLOAT) {
                    return CoreDatatype.XSD.FLOAT;
                }
                if (ld == CoreDatatype.XSD.DECIMAL || rd == CoreDatatype.XSD.DECIMAL) {
                    return CoreDatatype.XSD.DECIMAL;
                }
                return CoreDatatype.XSD.INTEGER;
            }
            if (!strict && ld.isCalendarDatatype() && rd.isCalendarDatatype()) {
                return CoreDatatype.XSD.DATETIME;
            }
            if (!strict && ld.isDurationDatatype() && rd.isDurationDatatype()) {
                return CoreDatatype.XSD.DURATION;
            }
        }
        return null;
    }

    public static boolean isPlainLiteral(Value v) {
        return v.isLiteral() && QueryEvaluationUtil.isPlainLiteral((Literal)v);
    }

    public static boolean isPlainLiteral(Literal l) {
        assert (l.getLanguage().isEmpty() || l.getCoreDatatype() == CoreDatatype.RDF.LANGSTRING);
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING || l.getCoreDatatype() == CoreDatatype.RDF.LANGSTRING;
    }

    public static boolean isSimpleLiteral(Value v) {
        return v.isLiteral() && QueryEvaluationUtil.isSimpleLiteral((Literal)v);
    }

    public static boolean isSimpleLiteral(Literal l) {
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING && !Literals.isLanguageLiteral((Literal)l);
    }

    public static boolean isSimpleLiteral(boolean lang, CoreDatatype dt) {
        return !lang && dt == CoreDatatype.XSD.STRING;
    }

    public static boolean isStringLiteral(Value v) {
        return v.isLiteral() && QueryEvaluationUtil.isStringLiteral((Literal)v);
    }

    public static boolean isStringLiteral(Literal l) {
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING || Literals.isLanguageLiteral((Literal)l);
    }

    private static boolean isSupportedDatatype(CoreDatatype.XSD dt) {
        return dt != null && (dt == CoreDatatype.XSD.STRING || dt.isNumericDatatype() || dt.isCalendarDatatype());
    }

    public static boolean compatibleArguments(Literal arg1, Literal arg2) {
        return QueryEvaluationUtil.isSimpleLiteral(arg1) && QueryEvaluationUtil.isSimpleLiteral(arg2) || Literals.isLanguageLiteral((Literal)arg1) && Literals.isLanguageLiteral((Literal)arg2) && arg1.getLanguage().equals(arg2.getLanguage()) || Literals.isLanguageLiteral((Literal)arg1) && QueryEvaluationUtil.isSimpleLiteral(arg2);
    }
}

