/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.evaluation;

import java.util.Comparator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;

public class RepositoryTripleSource
implements TripleSource {
    private final RepositoryConnection repo;
    private final boolean includeInferred;

    public RepositoryTripleSource(RepositoryConnection repo) {
        this(repo, true);
    }

    public RepositoryTripleSource(RepositoryConnection repo, boolean includeInferred) {
        this.repo = repo;
        this.includeInferred = includeInferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        RepositoryResult iter = null;
        QueryEvaluationCloseableIteration result = null;
        boolean allGood = false;
        try {
            iter = this.repo.getStatements(subj, pred, obj, this.includeInferred, contexts);
            result = new QueryEvaluationCloseableIteration(iter);
            allGood = true;
            QueryEvaluationCloseableIteration queryEvaluationCloseableIteration = result;
            return queryEvaluationCloseableIteration;
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        finally {
            if (!allGood) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (iter != null) {
                        iter.close();
                    }
                }
            }
        }
    }

    public ValueFactory getValueFactory() {
        return this.repo.getValueFactory();
    }

    public Comparator<Value> getComparator() {
        return null;
    }

    static class QueryEvaluationCloseableIteration<E>
    implements CloseableIteration<E> {
        private final CloseableIteration<? extends E> iter;

        public QueryEvaluationCloseableIteration(CloseableIteration<? extends E> iter) {
            this.iter = iter;
        }

        public void close() {
            try {
                this.iter.close();
            }
            catch (Exception e) {
                throw this.convert(e);
            }
        }

        public boolean hasNext() {
            try {
                return this.iter.hasNext();
            }
            catch (Exception e) {
                throw this.convert(e);
            }
        }

        public E next() {
            try {
                return (E)this.iter.next();
            }
            catch (Exception e) {
                throw this.convert(e);
            }
        }

        public void remove() {
            try {
                this.iter.remove();
            }
            catch (Exception e) {
                throw this.convert(e);
            }
        }

        protected QueryEvaluationException convert(Exception e) {
            if (e instanceof QueryEvaluationException) {
                return (QueryEvaluationException)e;
            }
            throw new QueryEvaluationException((Throwable)e);
        }
    }
}

