/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.zephyr;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.eclipse.rcptt.internal.zephyr.ZephyrRestClient;

public final class ZephyrVersion {
    private static final String URL_GET_VERSIONS = "%s/rest/api/2/project/%s/versions?expand";

    public static Map<String, Long> getAllVersions(ZephyrRestClient restClient, Long projectID) {
        HashMap<String, Long> versions;
        block15: {
            versions = new HashMap<String, Long>();
            String url = String.format(URL_GET_VERSIONS, restClient.getUrl(), projectID);
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (CloseableHttpResponse response = restClient.get(url);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode >= 200 && statusCode < 300) {
                        HttpEntity entity = response.getEntity();
                        String string = null;
                        try {
                            string = EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException | ParseException e) {
                            throw new IllegalArgumentException(String.format("Bad response entity upon receipt of versions <%s>", url), e);
                        }
                        JsonArray projArray = new JsonParser().parse(string).getAsJsonArray();
                        int i = 0;
                        while (i < projArray.size()) {
                            Long id = projArray.get(i).getAsJsonObject().get("id").getAsLong();
                            String projName = projArray.get(i).getAsJsonObject().get("name").getAsString();
                            versions.put(projName, id);
                            ++i;
                        }
                        break block15;
                    }
                    throw new IllegalArgumentException(String.format("Unexpected response status <%s> upon receipt of versions <%s>", statusCode, url));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return versions;
    }

    public static Long getVersionIdByName(ZephyrRestClient restClient, Long projectId, String versionName) {
        Map<String, Long> versions = ZephyrVersion.getAllVersions(restClient, projectId);
        Long versionId = versions.get(versionName);
        if (versionId == null) {
            throw new IllegalArgumentException(String.format("Version <%s> not found among <%s>", versionName, String.join((CharSequence)", ", versions.keySet())));
        }
        return versionId;
    }
}

