/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.util.ReportUtils;
import org.eclipse.rcptt.reporting.util.XMLReportGenerator;
import org.eclipse.rcptt.reporting.util.internal.Plugin;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public class FileReportGenerator
implements IReportRenderer {
    public IStatus generateReport(IReportRenderer.IContentFactory factory, String reportName, Iterable<Report> report) {
        Q7Statistics statistics = ReportUtils.calculateStatistics(report.iterator());
        OutputStream stream = null;
        try {
            try {
                stream = factory.createFileStream(reportName + ".xml");
                new XMLReportGenerator().generateContent(stream, reportName, report, statistics);
            }
            catch (CoreException cex) {
                IStatus iStatus = cex.getStatus();
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return Plugin.UTILS.createError((Throwable)e);
                }
                return iStatus;
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                return Plugin.UTILS.createError((Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public String[] getGeneratedFileNames(String reportName) {
        return new String[]{reportName + ".xml"};
    }
}

