/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.socket;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import org.apache.hc.client5.http.socket.Jep380SocketChannelAdapter;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class UnixDomainSocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UnixDomainSocketFactory.class);
    private static final String JDK_UNIX_SOCKET_ADDRESS_CLASS = "java.net.UnixDomainSocketAddress";
    private static final String JUNIXSOCKET_SOCKET_CLASS = "org.newsclub.net.unix.AFUNIXSocket";
    private static final String JUNIXSOCKET_ADDRESS_CLASS = "org.newsclub.net.unix.AFUNIXSocketAddress";
    private static final Implementation IMPLEMENTATION = UnixDomainSocketFactory.detectImplementation();
    private static final UnixDomainSocketFactory INSTANCE = new UnixDomainSocketFactory();

    private static Implementation detectImplementation() {
        try {
            Class.forName(JDK_UNIX_SOCKET_ADDRESS_CLASS);
            LOG.debug("Using JDK Unix Domain Socket implementation");
            return Implementation.JDK;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName(JUNIXSOCKET_SOCKET_CLASS);
                LOG.debug("Using JUnixSocket Unix Domain Socket implementation");
                return Implementation.JUNIXSOCKET;
            }
            catch (ClassNotFoundException e2) {
                LOG.debug("No Unix Domain Socket implementation found");
                return Implementation.NONE;
            }
        }
    }

    public static boolean isAvailable() {
        return IMPLEMENTATION != Implementation.NONE;
    }

    public static UnixDomainSocketFactory getSocketFactory() {
        return INSTANCE;
    }

    public SocketAddress createSocketAddress(Path socketPath) {
        if (!UnixDomainSocketFactory.isAvailable()) {
            throw new UnsupportedOperationException("Unix Domain Socket support is not available");
        }
        Args.notNull((Object)socketPath, (String)"Unix domain socket path");
        try {
            if (IMPLEMENTATION == Implementation.JDK) {
                Class<?> addressClass = Class.forName(JDK_UNIX_SOCKET_ADDRESS_CLASS);
                Method ofMethod = addressClass.getMethod("of", Path.class);
                return (SocketAddress)ofMethod.invoke(null, socketPath);
            }
            Class<?> addressClass = Class.forName(JUNIXSOCKET_ADDRESS_CLASS);
            Method ofMethod = addressClass.getMethod("of", Path.class);
            return (SocketAddress)ofMethod.invoke(null, socketPath);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Could not create UDS SocketAddress", ex);
        }
    }

    public Socket createSocket() throws IOException {
        if (!UnixDomainSocketFactory.isAvailable()) {
            throw new UnsupportedOperationException("Unix Domain Socket support is not available");
        }
        try {
            if (IMPLEMENTATION == Implementation.JDK) {
                try {
                    SocketChannel channel = (SocketChannel)SocketChannel.class.getMethod("open", ProtocolFamily.class).invoke(null, StandardProtocolFamily.valueOf("UNIX"));
                    return new Jep380SocketChannelAdapter(channel);
                }
                catch (ReflectiveOperationException ex) {
                    throw new UnsupportedOperationException("JEP 380 Unix domain sockets are not supported; use JUnixSocket", ex);
                }
            }
            Class<?> socketClass = Class.forName(JUNIXSOCKET_SOCKET_CLASS);
            Method newInstanceMethod = socketClass.getMethod("newInstance", new Class[0]);
            return (Socket)newInstanceMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Failed to create Unix domain socket", e);
        }
    }

    public Socket connectSocket(Socket socket, Path socketPath, TimeValue connectTimeout) throws IOException {
        Args.notNull((Object)socketPath, (String)"Unix domain socket path");
        Socket sock = socket != null ? socket : this.createSocket();
        SocketAddress address = this.createSocketAddress(socketPath);
        int connTimeoutMs = TimeValue.isPositive((TimeValue)connectTimeout) ? connectTimeout.toMillisecondsIntBound() : 0;
        try {
            sock.connect(address, connTimeoutMs);
            return sock;
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }

    private static enum Implementation {
        JDK,
        JUNIXSOCKET,
        NONE;

    }
}

