/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.DecoratingVetoableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.internal.databinding.swt.WidgetListenerUtil;
import org.eclipse.jface.internal.databinding.swt.WidgetStringValueProperty;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SWTVetoableValueDecorator
extends DecoratingVetoableValue<String>
implements ISWTObservableValue<String> {
    private Widget widget;
    private WidgetStringValueProperty<Widget> property;
    private final Listener verifyListener = event -> {
        String newText;
        String currentText = (String)this.property.getValue(this.widget);
        if (!this.fireValueChanging(Diffs.createValueDiff((Object)currentText, (Object)(newText = currentText.substring(0, event.start) + event.text + currentText.substring(event.end))))) {
            event.doit = false;
        }
    };
    private final Listener disposeListener = event -> this.dispose();

    public SWTVetoableValueDecorator(Widget widget, WidgetStringValueProperty<? extends Widget> property, IObservableValue<String> decorated) {
        super(decorated, true);
        this.property = property;
        this.widget = widget;
        Assert.isTrue((boolean)decorated.getValueType().equals(String.class), (String)"SWTVetoableValueDecorator can only decorate observable values of String value type");
        WidgetListenerUtil.asyncAddListener(widget, 12, this.disposeListener);
    }

    protected void firstListenerAdded() {
        super.firstListenerAdded();
        WidgetListenerUtil.asyncAddListener(this.widget, 25, this.verifyListener);
    }

    protected void lastListenerRemoved() {
        WidgetListenerUtil.asyncRemoveListener(this.widget, 25, this.verifyListener);
        super.lastListenerRemoved();
    }

    public synchronized void dispose() {
        WidgetListenerUtil.asyncRemoveListener(this.widget, 25, this.verifyListener);
        WidgetListenerUtil.asyncRemoveListener(this.widget, 12, this.disposeListener);
        this.widget = null;
        super.dispose();
    }

    @Override
    public Widget getWidget() {
        return this.widget;
    }
}

