/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.impl;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.PreferencesPackage;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.impl.PreferenceNodeImpl;
import org.eclipse.oomph.preferences.impl.PropertyImpl;
import org.eclipse.oomph.util.StringUtil;

public class PreferencesFactoryImpl
extends EFactoryImpl
implements PreferencesFactory {
    private Map<String, URI> PREFERENCE_URIS = Collections.synchronizedMap(new WeakHashMap());
    private static final String[] ESCAPES = new String[]{"\\000", "\\001", "\\002", "\\003", "\\004", "\\005", "\\006", "\\007", "\\010", "\t", "\n", "\\013", "\\014", "\r", "\\016", "\\017", "\\020", "\\021", "\\022", "\\023", "\\024", "\\025", "\\026", "\\027", "\\030", "\\031", "\\032", "\\033", "\\034", "\\035", "\\036", "\\037"};

    public static PreferencesFactory init() {
        try {
            PreferencesFactory thePreferencesFactory = (PreferencesFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/Oomph/preferences/1.0");
            if (thePreferencesFactory != null) {
                return thePreferencesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new PreferencesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createPreferenceNode();
            }
            case 2: {
                return this.createProperty();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createEscapedStringFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createURIFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createPreferenceNodeNameFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertEscapedStringToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertURIToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertPreferenceNodeNameToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public PreferenceNode createPreferenceNode() {
        PreferenceNodeImpl preferenceNode = new PreferenceNodeImpl();
        return preferenceNode;
    }

    @Override
    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    @Override
    public String createEscapedString(String literal) {
        return StringUtil.unescape((String)literal);
    }

    public String createEscapedStringFromString(EDataType eDataType, String initialValue) {
        return this.createEscapedString(initialValue);
    }

    @Override
    public String convertEscapedString(String instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        int length = instanceValue.length();
        while (i < length) {
            char c = instanceValue.charAt(i);
            if (c < ESCAPES.length) {
                result.append(ESCAPES[c]);
            } else if (c == '\\') {
                result.append("\\\\");
            } else if (c == '\u007f') {
                result.append("\\177");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public String convertEscapedStringToString(EDataType eDataType, Object instanceValue) {
        return this.convertEscapedString((String)instanceValue);
    }

    @Override
    public URI createURI(String literal) {
        if (literal == null) {
            return null;
        }
        URI result = this.PREFERENCE_URIS.get(literal);
        if (result == null) {
            String[] segments = literal.split("/");
            int length = segments.length;
            if (length == 0) {
                result = URI.createHierarchicalURI(null, (String)"", null, null, null);
            } else {
                result = URI.createURI((String)"");
                StringBuilder property = null;
                boolean startProperty = false;
                int start = -1;
                int i = 0;
                while (i < length) {
                    String segment = segments[i];
                    if (property != null) {
                        if (startProperty) {
                            property.append('/');
                        } else {
                            startProperty = true;
                        }
                        property.append(segment);
                    } else if (segment.length() == 0) {
                        if (i == 0) {
                            if (i != length - 1) {
                                result = URI.createHierarchicalURI(null, (String)"", null, null, null);
                            }
                            start = 1;
                        } else {
                            property = new StringBuilder();
                        }
                    } else {
                        result = i == start ? URI.createHierarchicalURI(null, (String)URI.encodeAuthority((String)segment, (boolean)false), null, null, null) : result.appendSegment(URI.encodeSegment((String)segment, (boolean)false));
                    }
                    ++i;
                }
                if (property != null) {
                    result = result.appendSegment(URI.encodeSegment((String)property.toString(), (boolean)false));
                }
            }
            this.PREFERENCE_URIS.put(literal, result);
        }
        return result;
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return this.createURI(initialValue);
    }

    @Override
    public String convertURI(URI instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String authority = instanceValue.authority();
        if (authority != null) {
            result.append('/');
            result.append(URI.decode((String)authority));
        }
        String[] stringArray = instanceValue.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String decodedSegment;
            String segment = stringArray[n2];
            if (result.length() != 0) {
                result.append('/');
            }
            if ((decodedSegment = URI.decode((String)segment)).contains("/")) {
                result.append('/');
            }
            result.append(decodedSegment);
            ++n2;
        }
        return result.toString();
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        return this.convertURI((URI)instanceValue);
    }

    @Override
    public String createPreferenceNodeName(String literal) {
        return (String)super.createFromString(PreferencesPackage.Literals.PREFERENCE_NODE_NAME, literal);
    }

    public String createPreferenceNodeNameFromString(EDataType eDataType, String initialValue) {
        return this.createPreferenceNodeName(initialValue);
    }

    @Override
    public String convertPreferenceNodeName(String instanceValue) {
        return super.convertToString(PreferencesPackage.Literals.PREFERENCE_NODE_NAME, (Object)instanceValue);
    }

    public String convertPreferenceNodeNameToString(EDataType eDataType, Object instanceValue) {
        return this.convertPreferenceNodeName((String)instanceValue);
    }

    @Override
    public PreferencesPackage getPreferencesPackage() {
        return (PreferencesPackage)this.getEPackage();
    }

    @Deprecated
    public static PreferencesPackage getPackage() {
        return PreferencesPackage.eINSTANCE;
    }
}

