/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSEngineHelper {
    private IEclipseContext context;
    private Control control;
    private IStylingEngine engine;
    private CSSStyleDeclaration style;

    public CSSEngineHelper(IEclipseContext context, Control control) {
        this.context = context;
        this.control = control;
        this.initialize();
    }

    private void initialize() {
        this.engine = (IStylingEngine)this.context.get(IStylingEngine.class);
        if (this.engine != null) {
            this.style = this.engine.getStyle((Object)this.control);
        }
    }

    public int getMarginBottom(int defaultValue) {
        if (this.style == null) {
            return defaultValue;
        }
        return this.getPxValue(this.style.getPropertyCSSValue("margin-bottom"), defaultValue);
    }

    public int getMarginTop(int defaultValue) {
        if (this.style == null) {
            return defaultValue;
        }
        return this.getPxValue(this.style.getPropertyCSSValue("margin-top"), defaultValue);
    }

    public int getMarginLeft(int defaultValue) {
        if (this.style == null) {
            return defaultValue;
        }
        return this.getPxValue(this.style.getPropertyCSSValue("margin-left"), defaultValue);
    }

    public int getMarginRight(int defaultValue) {
        if (this.style == null) {
            return defaultValue;
        }
        return this.getPxValue(this.style.getPropertyCSSValue("margin-right"), defaultValue);
    }

    private int getPxValue(CSSValue value, int defaultValue) {
        if (value != null && value.getCssValueType() == 1 && ((CSSPrimitiveValue)value).getPrimitiveType() == 5) {
            return (int)((CSSPrimitiveValue)value).getFloatValue((short)5);
        }
        return defaultValue;
    }
}

