/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ImportOperation
extends WorkspaceModifyOperation {
    private static final int POLICY_DEFAULT = 0;
    private static final int POLICY_SKIP_CHILDREN = 1;
    private static final int POLICY_FORCE_OVERWRITE = 2;
    private Object source;
    private final IPath destinationPath;
    private IContainer destinationContainer;
    private List<?> selectedFiles;
    private List<IPath> rejectedFiles;
    private final IImportStructureProvider provider;
    protected IOverwriteQuery overwriteCallback;
    private Shell context;
    private final List<IStatus> errorTable = new ArrayList<IStatus>();
    private boolean createVirtualFolder = false;
    private boolean createLinks = false;
    private final boolean createLinkFilesOnly = false;
    private String relativeVariable = null;
    private boolean createContainerStructure = true;
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;
    private static final String ABSOLUTE_PATH = "<Absolute Path>";

    public ImportOperation(IPath containerPath, Object source, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor) {
        this.destinationPath = containerPath;
        this.source = source;
        this.provider = provider;
        this.overwriteCallback = overwriteImplementor;
    }

    public ImportOperation(IPath containerPath, Object source, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor, List filesToImport) {
        this(containerPath, source, provider, overwriteImplementor);
        this.setFilesToImport(filesToImport);
    }

    public ImportOperation(IPath containerPath, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor, List filesToImport) {
        this(containerPath, null, provider, overwriteImplementor);
        this.setFilesToImport(filesToImport);
    }

    void collectExistingReadonlyFiles(IPath sourceStart, List<?> sources, ArrayList<IPath> noOverwrite, ArrayList<IPath> overwriteReadonly, int policy, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Iterator<?> sourceIter = sources.iterator();
        IPath sourceRootPath = null;
        if (this.source != null) {
            sourceRootPath = IPath.fromOSString((String)this.provider.getFullPath(this.source));
        }
        while (sourceIter.hasNext()) {
            IPath newDestinationPath;
            Object nextSource = sourceIter.next();
            IPath sourcePath = IPath.fromOSString((String)this.provider.getFullPath(nextSource));
            if (sourceRootPath == null) {
                newDestinationPath = sourceStart.append(this.provider.getLabel(nextSource));
            } else {
                int prefixLength = sourcePath.matchingFirstSegments(sourceRootPath);
                IPath relativeSourcePath = sourcePath.removeFirstSegments(prefixLength);
                newDestinationPath = this.destinationPath.append(relativeSourcePath);
            }
            IResource newDestination = workspaceRoot.findMember(newDestinationPath);
            if (newDestination == null) continue;
            IFolder folder = this.getFolder(newDestination);
            if (folder != null) {
                if (this.provider.isFolder(nextSource) && this.overwriteState == 2) {
                    this.collectExistingReadonlyFiles(newDestinationPath, this.provider.getChildren(nextSource), noOverwrite, overwriteReadonly, 2, (IProgressMonitor)subMonitor.split(100));
                    continue;
                }
                if (policy == 2 || this.overwriteState != 1 && this.queryOverwrite(newDestinationPath)) continue;
                noOverwrite.add(folder.getFullPath());
                continue;
            }
            IFile file = this.getFile(newDestination);
            if (file == null) continue;
            if (!this.queryOverwriteFile(file, policy)) {
                noOverwrite.add(file.getFullPath());
                continue;
            }
            if (!file.isReadOnly()) continue;
            overwriteReadonly.add(file.getFullPath());
        }
    }

    IContainer createContainersFor(IPath path) throws CoreException {
        IContainer currentFolder = this.destinationContainer;
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return currentFolder;
        }
        if (currentFolder.getType() == 8) {
            return this.createFromRoot(path);
        }
        int i = 0;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder(IPath.fromOSString((String)path.segment(i)))).exists()) {
                if (this.createVirtualFolder) {
                    ((IFolder)currentFolder).create(8192, true, null);
                } else if (this.createLinks) {
                    ((IFolder)currentFolder).createLink(this.createRelativePath(path, (IResource)currentFolder), 0, null);
                } else {
                    ((IFolder)currentFolder).create(false, true, null);
                }
            }
            ++i;
        }
        return currentFolder;
    }

    private IContainer createFromRoot(IPath path) throws CoreException {
        int segmentCount = path.segmentCount();
        IProject currentFolder = ((IWorkspaceRoot)this.destinationContainer).getProject(path.segment(0));
        int i = 1;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder(IPath.fromOSString((String)path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(false, true, null);
            }
            ++i;
        }
        return currentFolder;
    }

    void deleteResource(IResource resource) {
        try {
            resource.delete(2, null);
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
        }
    }

    @Override
    protected void execute(IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)DataTransferMessages.DataTransfer_importTask, (int)100);
        try {
            if (this.selectedFiles == null) {
                ContainerGenerator generator = new ContainerGenerator(this.destinationPath);
                subMonitor.worked(3);
                this.validateFiles(Arrays.asList(this.source), (IProgressMonitor)subMonitor.split(3));
                this.destinationContainer = generator.generateContainer((IProgressMonitor)subMonitor.split(4));
                this.importRecursivelyFrom(this.source, 0, (IProgressMonitor)subMonitor.split(90));
            } else {
                ContainerGenerator generator = new ContainerGenerator(this.destinationPath);
                subMonitor.worked(3);
                this.validateFiles(this.selectedFiles, (IProgressMonitor)subMonitor.split(3));
                this.destinationContainer = generator.generateContainer((IProgressMonitor)subMonitor.split(4));
                this.importFileSystemObjects(this.selectedFiles, (IProgressMonitor)subMonitor.split(90));
            }
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
        }
    }

    IContainer getDestinationContainerFor(Object fileSystemObject) throws CoreException {
        IPath pathname = IPath.fromOSString((String)this.provider.getFullPath(fileSystemObject));
        if (this.createContainerStructure) {
            return this.createContainersFor(pathname.removeLastSegments(1));
        }
        if (this.source == fileSystemObject) {
            return null;
        }
        IPath sourcePath = IPath.fromOSString((String)this.provider.getFullPath(this.source));
        IPath destContainerPath = pathname.removeLastSegments(1);
        IPath relativePath = destContainerPath.removeFirstSegments(sourcePath.segmentCount()).setDevice(null);
        return this.createContainersFor(relativePath);
    }

    IFile getFile(IResource resource) {
        return (IFile)Adapters.adapt((Object)resource, IFile.class);
    }

    IFolder getFolder(IResource resource) {
        return (IFolder)Adapters.adapt((Object)resource, IFolder.class);
    }

    ArrayList<IPath> getRejectedFiles(IStatus multiStatus, IFile[] files) {
        ArrayList<IPath> filteredFiles = new ArrayList<IPath>();
        IStatus[] status = multiStatus.getChildren();
        int i = 0;
        while (i < status.length) {
            if (!status[i].isOK()) {
                this.errorTable.add(status[i]);
                filteredFiles.add(files[i].getFullPath());
            }
            ++i;
        }
        return filteredFiles;
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, DataTransferMessages.ImportOperation_importProblems, null);
    }

    void importFile(Object fileObject, int policy, IProgressMonitor mon) {
        IContainer containerResource;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        try {
            containerResource = this.getDestinationContainerFor(fileObject);
        }
        catch (CoreException e) {
            IStatus coreStatus = e.getStatus();
            String newMessage = NLS.bind((String)DataTransferMessages.ImportOperation_coreImportError, (Object)fileObject, (Object)coreStatus.getMessage());
            Status status = new Status(coreStatus.getSeverity(), coreStatus.getPlugin(), coreStatus.getCode(), newMessage, null);
            this.errorTable.add((IStatus)status);
            return;
        }
        String fileObjectPath = this.provider.getFullPath(fileObject);
        subMonitor.subTask(fileObjectPath);
        IFile targetResource = containerResource.getFile(IPath.fromOSString((String)this.provider.getLabel(fileObject)));
        if (this.rejectedFiles.contains(targetResource.getFullPath())) {
            return;
        }
        IPath targetPath = targetResource.getLocation();
        if (targetPath != null && targetPath.toFile().equals(new File(fileObjectPath))) {
            this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_targetSameAsSourceError, (Object)fileObjectPath), null));
            return;
        }
        try {
            Throwable status = null;
            Object var10_17 = null;
            try (InputStream contentStream = this.provider.getContents(fileObject);){
                if (contentStream == null) {
                    if (this.isNotReadableFile(fileObject)) {
                        this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_cannotReadError, (Object)fileObjectPath), null));
                    } else {
                        this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_openStreamError, (Object)fileObjectPath), null));
                    }
                    return;
                }
                if (this.createVirtualFolder || this.createLinks) {
                    if (targetResource.exists()) {
                        targetResource.delete(true, (IProgressMonitor)subMonitor.split(50));
                    }
                    targetResource.createLink(this.createRelativePath(IPath.fromOSString((String)this.provider.getFullPath(fileObject)), (IResource)targetResource), 0, (IProgressMonitor)subMonitor.split(50));
                } else if (targetResource.exists()) {
                    if (targetResource.isLinked()) {
                        targetResource.delete(true, (IProgressMonitor)subMonitor.split(50));
                        targetResource.create(contentStream, false, (IProgressMonitor)subMonitor.split(50));
                    } else {
                        targetResource.setContents(contentStream, 2, (IProgressMonitor)subMonitor.split(100));
                    }
                } else {
                    targetResource.create(contentStream, false, (IProgressMonitor)subMonitor.split(100));
                }
                this.setResourceAttributes(targetResource, fileObject);
                if (this.provider instanceof TarLeveledStructureProvider) {
                    try {
                        targetResource.setResourceAttributes(((TarLeveledStructureProvider)this.provider).getResourceAttributes(fileObject));
                    }
                    catch (CoreException e) {
                        this.errorTable.add(e.getStatus());
                    }
                }
            }
            catch (Throwable throwable) {
                if (status == null) {
                    status = throwable;
                } else if (status != throwable) {
                    status.addSuppressed(throwable);
                }
                throw status;
            }
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
        }
        catch (IOException e) {
            this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_closeStreamError, (Object)fileObjectPath), (Throwable)e));
        }
    }

    private boolean isNotReadableFile(Object file) {
        if (!(file instanceof File)) {
            return false;
        }
        Path path = ((File)file).toPath();
        boolean readable = Files.isReadable(path);
        boolean regular = Files.isRegularFile(path, new LinkOption[0]);
        return regular && !readable;
    }

    private void setResourceAttributes(IFile targetResource, Object fileObject) {
        long zipTimeStamp;
        long timeStamp = 0L;
        if (fileObject instanceof File) {
            try {
                targetResource.setResourceAttributes(ResourceAttributes.fromFile((File)((File)fileObject)));
                timeStamp = ((File)fileObject).lastModified();
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        } else if (fileObject instanceof TarEntry) {
            try {
                targetResource.setResourceAttributes(((TarLeveledStructureProvider)this.provider).getResourceAttributes(fileObject));
                timeStamp = ((TarEntry)fileObject).getTime() * 1000L;
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        } else if (fileObject instanceof ZipEntry && (zipTimeStamp = ((ZipEntry)fileObject).getTime()) != -1L) {
            timeStamp = zipTimeStamp;
        }
        if (timeStamp != 0L) {
            try {
                targetResource.setLocalTimeStamp(timeStamp);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    void importFileSystemObjects(List<?> filesToImport, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToImport.size());
        Iterator<?> filesEnum = filesToImport.iterator();
        while (filesEnum.hasNext()) {
            SubMonitor iterationMonitor = subMonitor.split(1);
            Object fileSystemObject = filesEnum.next();
            if (this.source == null) {
                IPath sourcePath = IPath.fromOSString((String)this.provider.getFullPath(fileSystemObject)).removeLastSegments(1);
                if (this.provider.isFolder(fileSystemObject) && sourcePath.isEmpty()) {
                    this.errorTable.add((IStatus)new Status(1, "org.eclipse.ui", 0, DataTransferMessages.ImportOperation_cannotCopy, null));
                    continue;
                }
                this.source = sourcePath.toFile();
            }
            this.importRecursivelyFrom(fileSystemObject, 0, (IProgressMonitor)iterationMonitor);
        }
    }

    int importFolder(Object folderObject, int policy, IProgressMonitor monitor) throws CoreException {
        IContainer containerResource;
        try {
            containerResource = this.getDestinationContainerFor(folderObject);
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
            return policy;
        }
        if (containerResource == null) {
            return policy;
        }
        monitor.subTask(this.provider.getFullPath(folderObject));
        IWorkspace workspace = this.destinationContainer.getWorkspace();
        IPath containerPath = containerResource.getFullPath();
        IPath resourcePath = containerPath.append(this.provider.getLabel(folderObject));
        if (resourcePath.equals((Object)containerPath)) {
            return policy;
        }
        if (workspace.getRoot().exists(resourcePath)) {
            if (this.rejectedFiles.contains(resourcePath)) {
                return 1;
            }
            IFolder folder = workspace.getRoot().getFolder(resourcePath);
            if (this.createVirtualFolder || this.createLinks || folder.isVirtual() || folder.isLinked()) {
                folder.delete(true, null);
            } else {
                return 2;
            }
        }
        try {
            if (this.createVirtualFolder) {
                workspace.getRoot().getFolder(resourcePath).create(8192, true, null);
            } else if (this.createLinks) {
                IFolder newFolder = workspace.getRoot().getFolder(resourcePath);
                newFolder.createLink(this.createRelativePath(IPath.fromOSString((String)this.provider.getFullPath(folderObject)), (IResource)newFolder), 0, null);
                policy = 1;
            } else {
                workspace.getRoot().getFolder(resourcePath).create(false, true, null);
            }
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
        }
        return policy;
    }

    private IPath createRelativePath(IPath location, IResource resource) {
        if (this.relativeVariable == null) {
            return location;
        }
        if (this.relativeVariable.equals(ABSOLUTE_PATH)) {
            return location;
        }
        IPathVariableManager pathVariableManager = resource.getPathVariableManager();
        try {
            return URIUtil.toPath((URI)pathVariableManager.convertToRelative(URIUtil.toURI((IPath)location), true, this.relativeVariable));
        }
        catch (CoreException e) {
            return location;
        }
    }

    void importRecursivelyFrom(Object fileSystemObject, int policy, IProgressMonitor mon) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        if (!this.provider.isFolder(fileSystemObject)) {
            this.importFile(fileSystemObject, policy, (IProgressMonitor)subMonitor.split(100));
            return;
        }
        int childPolicy = this.importFolder(fileSystemObject, policy, (IProgressMonitor)subMonitor.split(10));
        if (childPolicy != 1) {
            List children = this.provider.getChildren(fileSystemObject);
            SubMonitor loopMonitor = subMonitor.split(90).setWorkRemaining(children.size());
            for (Object child : children) {
                this.importRecursivelyFrom(child, childPolicy, (IProgressMonitor)loopMonitor.split(1));
            }
        }
    }

    boolean queryOverwrite(IPath resourcePath) throws OperationCanceledException {
        String overwriteAnswer = this.overwriteCallback.queryOverwrite(resourcePath.makeRelative().toString());
        if (overwriteAnswer.equals("CANCEL")) {
            throw new OperationCanceledException(DataTransferMessages.DataTransfer_emptyString);
        }
        if (overwriteAnswer.equals("NO")) {
            return false;
        }
        if (overwriteAnswer.equals("NOALL")) {
            this.overwriteState = 1;
            return false;
        }
        if (overwriteAnswer.equals("ALL")) {
            this.overwriteState = 2;
        }
        return true;
    }

    boolean queryOverwriteFile(IFile targetFile, int policy) {
        if (policy != 2) {
            if (this.overwriteState == 0 && !this.queryOverwrite(targetFile.getFullPath())) {
                return false;
            }
            if (this.overwriteState == 1) {
                return false;
            }
        }
        return true;
    }

    public void setContext(Shell shell) {
        this.context = shell;
    }

    public void setCreateContainerStructure(boolean value) {
        this.createContainerStructure = value;
    }

    public void setFilesToImport(List filesToImport) {
        this.selectedFiles = filesToImport;
    }

    public void setOverwriteResources(boolean value) {
        if (value) {
            this.overwriteState = 2;
        }
    }

    ArrayList<IPath> validateEdit(List<IPath> existingFiles) {
        if (existingFiles.size() > 0) {
            IFile[] files = existingFiles.toArray(new IFile[existingFiles.size()]);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateEdit(files, (Object)this.context);
            if (status.isMultiStatus()) {
                return this.getRejectedFiles(status, files);
            }
            if (!status.isOK()) {
                this.errorTable.add(status);
                ArrayList<IPath> filteredFiles = new ArrayList<IPath>();
                IFile[] iFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file = iFileArray[n2];
                    filteredFiles.add(file.getFullPath());
                    ++n2;
                }
                return filteredFiles;
            }
        }
        return new ArrayList<IPath>();
    }

    void validateFiles(List<?> sourceFiles, IProgressMonitor monitor) {
        ArrayList<IPath> noOverwrite = new ArrayList<IPath>();
        ArrayList<IPath> overwriteReadonly = new ArrayList<IPath>();
        this.collectExistingReadonlyFiles(this.destinationPath, sourceFiles, noOverwrite, overwriteReadonly, 0, monitor);
        this.rejectedFiles = this.validateEdit(overwriteReadonly);
        this.rejectedFiles.addAll(noOverwrite);
    }

    public void setVirtualFolders(boolean virtualFolders) {
        this.createVirtualFolder = virtualFolders;
    }

    public void setCreateLinks(boolean links) {
        this.createLinks = links;
    }

    public void setRelativeVariable(String variable) {
        this.relativeVariable = variable;
    }
}

