/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs.cpd;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.cpd.CustomizePerspectiveDialog;
import org.eclipse.ui.internal.dialogs.cpd.NameAndDescriptionToolTip;
import org.eclipse.ui.internal.dialogs.cpd.TreeManager;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IBindingService;

class ItemDetailToolTip
extends NameAndDescriptionToolTip {
    private final Tree tree;
    private final boolean showActionSet;
    private final boolean showKeyBindings;
    private final ViewerFilter filter;
    private final TreeViewer v;
    private final CustomizePerspectiveDialog dialog;

    ItemDetailToolTip(CustomizePerspectiveDialog dialog, TreeViewer v, Tree tree, boolean showActionSet, boolean showKeyBindings, ViewerFilter filter) {
        super((Control)tree, 2);
        this.dialog = dialog;
        this.tree = tree;
        this.v = v;
        this.showActionSet = showActionSet;
        this.showKeyBindings = showKeyBindings;
        this.filter = filter;
        this.setHideOnMouseDown(false);
    }

    public Point getLocation(Point tipSize, Event event) {
        ViewerCell cell = this.v.getCell(new Point(event.x, event.y));
        if (cell != null) {
            return this.tree.toDisplay(event.x, cell.getBounds().y + cell.getBounds().height);
        }
        return super.getLocation(tipSize, event);
    }

    protected Object getToolTipArea(Event event) {
        return this.v.getCell(new Point(event.x, event.y));
    }

    @Override
    protected void addContent(Composite destination, Object modelElement) {
        ICommandService commandService;
        Command command;
        final CustomizePerspectiveDialog.DisplayItem item = (CustomizePerspectiveDialog.DisplayItem)modelElement;
        if (this.showActionSet) {
            String text = null;
            boolean effectivelyAvailable = CustomizePerspectiveDialog.isEffectivelyAvailable(item, this.filter);
            if (effectivelyAvailable) {
                if (item.actionSet != null) {
                    actionSetName = item.getActionSet().descriptor.getLabel();
                    text = NLS.bind((String)WorkbenchMessages.HideItems_itemInActionSet, (Object)actionSetName);
                }
            } else if (item.getChildren().isEmpty() && item.getActionSet() != null) {
                actionSetName = item.getActionSet().descriptor.getLabel();
                text = NLS.bind((String)WorkbenchMessages.HideItems_itemInUnavailableActionSet, (Object)actionSetName);
            } else if (item.getChildren().isEmpty() && item.getActionSet() == null && item.getIContributionItem() instanceof HandledContributionItem) {
                text = WorkbenchMessages.HideItems_itemInUnavailableCommand;
            } else {
                LinkedHashSet<CustomizePerspectiveDialog.ActionSet> actionGroup = new LinkedHashSet<CustomizePerspectiveDialog.ActionSet>();
                ItemDetailToolTip.collectDescendantCommandGroups(actionGroup, item, this.filter);
                if (actionGroup.size() == 1) {
                    CustomizePerspectiveDialog.ActionSet actionSet = (CustomizePerspectiveDialog.ActionSet)actionGroup.iterator().next();
                    text = NLS.bind((String)WorkbenchMessages.HideItems_unavailableChildCommandGroup, (Object)actionSet.descriptor.getId(), (Object)actionSet.descriptor.getLabel());
                } else {
                    String commandGroupList = null;
                    for (CustomizePerspectiveDialog.ActionSet actionSet : actionGroup) {
                        String commandGroupLink = MessageFormat.format("<a href=\"{0}\">{1}</a>", actionSet.descriptor.getId(), actionSet.descriptor.getLabel());
                        commandGroupList = commandGroupList == null ? commandGroupLink : Util.createList(commandGroupList, commandGroupLink);
                    }
                    commandGroupList = NLS.bind((String)"{0}{1}", (Object[])new Object[]{CustomizePerspectiveDialog.NEW_LINE, commandGroupList});
                    text = NLS.bind((String)WorkbenchMessages.HideItems_unavailableChildCommandGroups, (Object)commandGroupList);
                }
            }
            if (text != null) {
                Image warningImage;
                if (!effectivelyAvailable) {
                    warningImage = this.dialog.warningImageDescriptor.createImage();
                    destination.addDisposeListener(e -> warningImage.dispose());
                } else {
                    warningImage = null;
                }
                Link link = this.createEntryWithLink(destination, warningImage, text);
                link.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        CustomizePerspectiveDialog.ActionSet actionSet = ItemDetailToolTip.this.dialog.idToActionSet.get(e.text);
                        if (actionSet == null) {
                            ItemDetailToolTip.this.hide();
                            ItemDetailToolTip.this.dialog.showActionSet(item);
                        } else {
                            ItemDetailToolTip.this.hide();
                            ItemDetailToolTip.this.dialog.showActionSet(actionSet);
                        }
                    }
                });
            }
        }
        if (this.showKeyBindings && CustomizePerspectiveDialog.getCommandID(item) != null && (command = (commandService = this.dialog.window.getService(ICommandService.class)).getCommand(CustomizePerspectiveDialog.getCommandID(item))) != null && command.isDefined()) {
            Binding highlight;
            boolean available;
            Binding[] bindings = ItemDetailToolTip.getKeyBindings(this.dialog.window, item);
            String keybindings = ItemDetailToolTip.keyBindingsAsString(bindings);
            String text = null;
            boolean bl = available = item.getActionSet() == null || item.getActionSet().isActive();
            text = bindings.length > 0 ? (available ? NLS.bind((String)WorkbenchMessages.HideItems_keyBindings, (Object)keybindings) : NLS.bind((String)WorkbenchMessages.HideItems_keyBindingsActionSetUnavailable, (Object)keybindings)) : (available ? WorkbenchMessages.HideItems_noKeyBindings : WorkbenchMessages.HideItems_noKeyBindingsActionSetUnavailable);
            if (bindings.length == 0) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (item instanceof CustomizePerspectiveDialog.ShortcutItem) {
                    if (CustomizePerspectiveDialog.isNewWizard(item)) {
                        parameters.put("newWizardId", CustomizePerspectiveDialog.getParamID(item));
                    } else if (CustomizePerspectiveDialog.isShowPerspective(item)) {
                        parameters.put("org.eclipse.ui.perspectives.showPerspective.perspectiveId", CustomizePerspectiveDialog.getParamID(item));
                    } else if (CustomizePerspectiveDialog.isShowView(item)) {
                        parameters.put("org.eclipse.ui.views.showView.viewId", CustomizePerspectiveDialog.getParamID(item));
                    }
                }
                ParameterizedCommand pc = ParameterizedCommand.generateCommand((Command)command, parameters);
                highlight = pc;
            } else {
                highlight = bindings[0];
            }
            Link bindingLink = this.createEntryWithLink(destination, null, text);
            bindingLink.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog pdialog = PreferencesUtil.createPreferenceDialogOn(ItemDetailToolTip.this.dialog.getShell(), "org.eclipse.ui.preferencePages.Keys", new String[0], highlight);
                    ItemDetailToolTip.this.hide();
                    pdialog.open();
                }
            });
        }
        if (item instanceof CustomizePerspectiveDialog.DynamicContributionItem) {
            CustomizePerspectiveDialog.DynamicContributionItem dynamic = (CustomizePerspectiveDialog.DynamicContributionItem)item;
            StringBuilder text = new StringBuilder();
            List<MenuItem> currentItems = dynamic.getCurrentItems();
            if (currentItems.size() > 0) {
                text.append(WorkbenchMessages.HideItems_dynamicItemList);
                for (MenuItem menuItem : currentItems) {
                    text.append(CustomizePerspectiveDialog.NEW_LINE).append("- ").append(menuItem.getText());
                }
            } else {
                text.append(WorkbenchMessages.HideItems_dynamicItemEmptyList);
            }
            this.createEntry(destination, null, text.toString());
        }
    }

    @Override
    protected Object getModelElement(Event event) {
        TreeItem treeItem = this.tree.getItem(new Point(event.x, event.y));
        if (treeItem == null) {
            return null;
        }
        return treeItem.getData();
    }

    static void collectDescendantCommandGroups(Collection<CustomizePerspectiveDialog.ActionSet> collection, CustomizePerspectiveDialog.DisplayItem item, ViewerFilter filter) {
        List<TreeManager.TreeItem> children = item.getChildren();
        for (TreeManager.TreeItem treeItem : children) {
            CustomizePerspectiveDialog.DisplayItem child = (CustomizePerspectiveDialog.DisplayItem)treeItem;
            if ((filter == null || filter.select(null, null, (Object)child)) && child.getActionSet() != null) {
                collection.add(child.getActionSet());
            }
            ItemDetailToolTip.collectDescendantCommandGroups(collection, child, filter);
        }
    }

    static String keyBindingsAsString(Binding[] bindings) {
        String keybindings = null;
        int i = 0;
        while (i < bindings.length) {
            boolean alreadyRecorded = false;
            int j = 0;
            while (j < i && !alreadyRecorded) {
                if (bindings[i].getTriggerSequence().equals((Object)bindings[j].getTriggerSequence())) {
                    alreadyRecorded = true;
                }
                ++j;
            }
            if (!alreadyRecorded) {
                String keybinding = bindings[i].getTriggerSequence().format();
                keybindings = i == 0 ? keybinding : Util.createList(keybindings, keybinding);
            }
            ++i;
        }
        return keybindings;
    }

    static Binding[] getKeyBindings(WorkbenchWindow window, CustomizePerspectiveDialog.DisplayItem item) {
        IBindingService bindingService = window.getService(IBindingService.class);
        if (!(bindingService instanceof BindingService)) {
            return new Binding[0];
        }
        String id = CustomizePerspectiveDialog.getCommandID(item);
        String param = CustomizePerspectiveDialog.getParamID(item);
        BindingManager bindingManager = ((BindingService)bindingService).getBindingManager();
        Collection allBindings = bindingManager.getActiveBindingsDisregardingContextFlat();
        ArrayList<Binding> foundBindings = new ArrayList<Binding>(2);
        for (Object name : allBindings) {
            Binding binding = (Binding)name;
            if (binding.getParameterizedCommand() == null || binding.getParameterizedCommand().getId() == null || !binding.getParameterizedCommand().getId().equals(id)) continue;
            if (param == null) {
                foundBindings.add(binding);
                continue;
            }
            Map m = binding.getParameterizedCommand().getParameterMap();
            String key = null;
            if (CustomizePerspectiveDialog.isNewWizard(item)) {
                key = "newWizardId";
            } else if (CustomizePerspectiveDialog.isShowView(item)) {
                key = "org.eclipse.ui.views.showView.viewId";
            } else if (CustomizePerspectiveDialog.isShowPerspective(item)) {
                key = "org.eclipse.ui.perspectives.showPerspective.perspectiveId";
            }
            if (key == null || !param.equals(m.get(key))) continue;
            foundBindings.add(binding);
        }
        return foundBindings.toArray(new Binding[foundBindings.size()]);
    }
}

