/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.wizards;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;

public class CommonWizardDescriptor
implements INavigatorContentExtPtConstants,
IPluginContribution {
    public static final String DEFAULT_MENU_GROUP_ID = "all-uncategorized";
    private String id;
    private String wizardId;
    private String menuGroupId;
    private String type;
    private Expression enablement;
    private final IConfigurationElement configElement;

    public CommonWizardDescriptor(IConfigurationElement aConfigElement) throws WorkbenchException {
        this.configElement = aConfigElement;
        this.init();
    }

    public CommonWizardDescriptor(IConfigurationElement aConfigElement, String anId) throws WorkbenchException {
        this.configElement = aConfigElement;
        this.id = anId;
        this.init();
    }

    public boolean isEnabledFor(IStructuredSelection aStructuredSelection) {
        if (this.enablement == null) {
            return false;
        }
        EvaluationContext context = null;
        IEvaluationContext parentContext = NavigatorPlugin.getApplicationContext();
        for (Object element : aStructuredSelection) {
            context = new EvaluationContext(parentContext, element);
            context.setAllowPluginActivation(true);
            if (NavigatorPlugin.safeEvaluate(this.enablement, (IEvaluationContext)context) != EvaluationResult.FALSE) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledFor(Object anElement) {
        if (this.enablement == null) {
            return false;
        }
        IEvaluationContext context = NavigatorPlugin.getEvalContext(anElement);
        return NavigatorPlugin.safeEvaluate(this.enablement, context) == EvaluationResult.TRUE;
    }

    void init() throws WorkbenchException {
        this.wizardId = this.configElement.getAttribute("wizardId");
        this.type = this.configElement.getAttribute("type");
        this.menuGroupId = this.configElement.getAttribute("menuGroupId");
        if (this.menuGroupId == null) {
            this.menuGroupId = DEFAULT_MENU_GROUP_ID;
        }
        if (this.id == null) {
            this.id = this.configElement.getAttribute("associatedExtensionId");
        }
        if (this.wizardId == null || this.wizardId.length() == 0) {
            throw new WorkbenchException("Missing attribute: wizardId in common wizard extension: " + this.configElement.getDeclaringExtension().getContributor().getName());
        }
        if (this.type == null || this.type.length() == 0) {
            throw new WorkbenchException("Missing attribute: type in common wizard extension: " + this.configElement.getDeclaringExtension().getContributor().getName());
        }
        IConfigurationElement[] children = this.configElement.getChildren("enablement");
        if (children.length == 1) {
            try {
                this.enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), children[0]);
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
            }
        } else if (children.length > 1) {
            throw new WorkbenchException("More than one element: enablement in common wizard extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
    }

    public String getWizardId() {
        return this.wizardId;
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.configElement.getDeclaringExtension().getNamespaceIdentifier();
    }

    public String getId() {
        return this.id;
    }

    public String getMenuGroupId() {
        return this.menuGroupId;
    }

    public String toString() {
        return "CommonWizardDescriptor[" + this.getId() + ", wizardId=" + this.getWizardId() + "]";
    }

    public String getLocalId() {
        return this.getWizardId();
    }

    public String getPluginId() {
        return this.configElement != null ? this.configElement.getNamespaceIdentifier() : null;
    }
}

