/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ShellActivationListener
implements Listener {
    public static final String DIALOG_IGNORE_KEY = "org.eclipse.e4.ui.ignoreDialog";
    private static final String ECLIPSE_CONTEXT_SHELL_CONTEXT = "org.eclipse.e4.ui.shellContext";
    private final MApplication application;

    ShellActivationListener(MApplication application) {
        this.application = application;
    }

    /*
     * WARNING - void declaration
     */
    public void handleEvent(Event event) {
        void shell;
        if (!(event.widget instanceof Shell)) {
            return;
        }
        Shell shell2 = (Shell)event.widget;
        Object obj = shell.getData("modelElement");
        if (obj instanceof MWindow) {
            this.processWindow(event, (Shell)shell, (MWindow)obj);
            return;
        }
        obj = shell.getData(DIALOG_IGNORE_KEY);
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            return;
        }
        switch (event.type) {
            case 26: {
                this.activate((Shell)shell);
                break;
            }
        }
    }

    private void processWindow(Event event, Shell shell, MWindow window) {
        switch (event.type) {
            case 26: {
                final IEclipseContext local = window.getContext();
                if (Policy.DEBUG_WORKBENCH) {
                    WorkbenchSWTActivator.trace("/trace/workbench", "setting mwindow context " + String.valueOf(local), null);
                }
                shell.setData(ECLIPSE_CONTEXT_SHELL_CONTEXT, (Object)local);
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        local.activateBranch();
                    }

                    public void handleException(Throwable exception) {
                        WorkbenchSWTActivator.trace("/trace/workbench", "failed correcting context chain", exception);
                    }
                });
                break;
            }
            case 27: {
                IEclipseContext context = window.getContext();
                if (Policy.DEBUG_WORKBENCH) {
                    WorkbenchSWTActivator.trace("/trace/workbench", "setting mwindow context " + String.valueOf(context), null);
                }
                shell.setData(ECLIPSE_CONTEXT_SHELL_CONTEXT, (Object)context);
            }
        }
    }

    private void activate(Shell shell) {
        IEclipseContext parentContext = this.application.getContext();
        final IEclipseContext shellContext = this.getShellContext(shell, parentContext);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                shellContext.activate();
            }

            public void handleException(Throwable exception) {
                WorkbenchSWTActivator.trace("/trace/workbench", "failed setting dialog child", exception);
            }
        });
    }

    private IEclipseContext getShellContext(Shell shell, IEclipseContext parentContext) {
        IEclipseContext shellContext = (IEclipseContext)shell.getData(ECLIPSE_CONTEXT_SHELL_CONTEXT);
        if (shellContext != null) {
            return shellContext;
        }
        IEclipseContext context = parentContext.createChild("org.eclipse.ui.contexts.dialog");
        context.set("localActiveShell", (Object)shell);
        shell.setData(ECLIPSE_CONTEXT_SHELL_CONTEXT, (Object)context);
        EContextService contextService = (EContextService)context.get(EContextService.class);
        contextService.activateContext("org.eclipse.ui.contexts.dialog");
        shell.addDisposeListener(e -> context.dispose());
        return context;
    }
}

