/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.viewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class ColumnViewerInformationControlToolTipSupport {
    protected static final String DEFAULT_FONT = JFaceResources.getFontRegistry().hasValueFor("org.eclipse.jdt.ui.javadocfont") ? "org.eclipse.jdt.ui.javadocfont" : "org.eclipse.jface.dialogfont";
    protected static String defaultStyleSheet;
    protected ColumnViewer viewer;
    protected Control control;
    protected LocationListener locationListener;
    protected ViewerCell currentCell;
    protected String text;
    protected Font font;
    protected Color backgroundColor;
    protected Color foregroundColor;
    protected AbstractReusableInformationControlCreator replacementInformationControlCreator = new AbstractReusableInformationControlCreator(){

        protected IInformationControl doCreateInformationControl(Shell parent) {
            DefaultInformationControl informationControl;
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                BrowserInformationControl browserInformationControl = new BrowserInformationControl(parent, ColumnViewerInformationControlToolTipSupport.this.getSymbolicFont(), true);
                browserInformationControl.addLocationListener(ColumnViewerInformationControlToolTipSupport.this.locationListener);
                informationControl = browserInformationControl;
            } else {
                informationControl = new DefaultInformationControl(parent, null);
            }
            if (ColumnViewerInformationControlToolTipSupport.this.foregroundColor != null) {
                informationControl.setForegroundColor(ColumnViewerInformationControlToolTipSupport.this.foregroundColor);
            }
            if (ColumnViewerInformationControlToolTipSupport.this.backgroundColor != null) {
                informationControl.setBackgroundColor(ColumnViewerInformationControlToolTipSupport.this.backgroundColor);
            }
            return informationControl;
        }
    };
    protected AbstractReusableInformationControlCreator reusableInformationControlCreator = new AbstractReusableInformationControlCreator(){

        protected IInformationControl doCreateInformationControl(Shell parent) {
            AccessibleInformationControl informationControl;
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                class AccessibleBrowserInformationControl
                extends BrowserInformationControl
                implements AccessibleInformationControl {
                    public AccessibleBrowserInformationControl(Shell parent, String symbolicFontName, String statusFieldText) {
                        super(parent, symbolicFontName, statusFieldText);
                    }

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return (this).ColumnViewerInformationControlToolTipSupport.this.replacementInformationControlCreator;
                    }

                    @Override
                    public Control getControl() {
                        return this.getShell();
                    }
                }
                AccessibleBrowserInformationControl accessibleBrowserInformationControl = new AccessibleBrowserInformationControl(parent, ColumnViewerInformationControlToolTipSupport.this.getSymbolicFont(), CommonUIPlugin.INSTANCE.getString("_UI_PressF2ForFocus_label"));
                informationControl = accessibleBrowserInformationControl;
            } else {
                class AccessibleDefaultInformationControl
                extends DefaultInformationControl
                implements AccessibleInformationControl {
                    public AccessibleDefaultInformationControl(Shell parent, String statusFieldText) {
                        super(parent, statusFieldText);
                    }

                    public void setInput(Object input) {
                        if (input instanceof BrowserInformationControlInput) {
                            this.setInformation(((BrowserInformationControlInput)input).getHtml());
                        } else {
                            this.setInformation((String)input);
                        }
                    }

                    @Override
                    public Control getControl() {
                        return this.getShell();
                    }
                }
                informationControl = new AccessibleDefaultInformationControl(parent, CommonUIPlugin.INSTANCE.getString("_UI_PressF2ForFocus_label"));
            }
            if (ColumnViewerInformationControlToolTipSupport.this.foregroundColor != null) {
                informationControl.setForegroundColor(ColumnViewerInformationControlToolTipSupport.this.foregroundColor);
            }
            if (ColumnViewerInformationControlToolTipSupport.this.backgroundColor != null) {
                informationControl.setBackgroundColor(ColumnViewerInformationControlToolTipSupport.this.backgroundColor);
            }
            return informationControl;
        }
    };
    protected AbstractHoverInformationControlManager hoverInformationControlManager = new AbstractHoverInformationControlManager((IInformationControlCreator)this.reusableInformationControlCreator){
        protected AbstractInformationControlManager.IInformationControlCloser closer;
        protected InformationControlReplacer replacer;
        protected KeyListener keyListener;
        {
            this.replacer = new InformationControlReplacer((IInformationControlCreator)ColumnViewerInformationControlToolTipSupport.this.replacementInformationControlCreator){
                {
                    this.setCloser(new Closer());
                }

                class Closer
                implements AbstractInformationControlManager.IInformationControlCloser,
                ControlListener,
                MouseListener,
                KeyListener,
                FocusListener,
                Listener {
                    protected boolean isActive;
                    protected Display display;
                    protected Control subjectControl;
                    protected IInformationControl informationControl;

                    Closer() {
                    }

                    public void setSubjectControl(Control control) {
                        this.subjectControl = control;
                    }

                    public void setInformationControl(IInformationControl control) {
                        this.informationControl = control;
                    }

                    public void start(Rectangle informationArea) {
                        if (!this.isActive) {
                            this.isActive = true;
                            if (this.subjectControl != null && !this.subjectControl.isDisposed()) {
                                this.subjectControl.addControlListener((ControlListener)this);
                                this.subjectControl.addMouseListener((MouseListener)this);
                                this.subjectControl.addKeyListener((KeyListener)this);
                            }
                            if (this.informationControl != null) {
                                this.informationControl.addFocusListener((FocusListener)this);
                            }
                            this.display = this.subjectControl.getDisplay();
                            if (!this.display.isDisposed()) {
                                this.display.addFilter(5, (Listener)this);
                                this.display.addFilter(16, (Listener)this);
                            }
                        }
                    }

                    public void stop() {
                        if (this.isActive) {
                            this.isActive = false;
                            if (this.subjectControl != null && !this.subjectControl.isDisposed()) {
                                this.subjectControl.removeControlListener((ControlListener)this);
                                this.subjectControl.removeMouseListener((MouseListener)this);
                                this.subjectControl.removeKeyListener((KeyListener)this);
                            }
                            if (this.informationControl != null) {
                                this.informationControl.removeFocusListener((FocusListener)this);
                            }
                            if (this.display != null && !this.display.isDisposed()) {
                                this.display.removeFilter(5, (Listener)this);
                                this.display.removeFilter(16, (Listener)this);
                            }
                            this.display = null;
                        }
                    }

                    public void controlResized(ControlEvent event) {
                        this.hideInformationControl();
                    }

                    public void controlMoved(ControlEvent event) {
                        this.hideInformationControl();
                    }

                    public void mouseDown(MouseEvent event) {
                        this.hideInformationControl();
                    }

                    public void mouseUp(MouseEvent event) {
                    }

                    public void mouseDoubleClick(MouseEvent event) {
                        this.hideInformationControl();
                    }

                    public void keyPressed(KeyEvent event) {
                        this.hideInformationControl();
                    }

                    public void keyReleased(KeyEvent event) {
                    }

                    public void focusGained(FocusEvent event) {
                    }

                    public void focusLost(FocusEvent event) {
                        if (this.display != null && !this.display.isDisposed()) {
                            this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    this.hideInformationControl();
                                }
                            });
                        }
                    }

                    public void handleEvent(Event event) {
                        if (event.type == 5) {
                            if (event.widget instanceof Control && event.widget.isDisposed()) {
                                if (this.informationControl != null && !this.informationControl.isFocusControl() && this.informationControl instanceof IInformationControlExtension3) {
                                    Point mouseLocation;
                                    Rectangle controlBounds = ((IInformationControlExtension3)this.informationControl).getBounds();
                                    if (controlBounds != null && !controlBounds.contains(mouseLocation = event.display.map((Control)event.widget, null, event.x, event.y))) {
                                        this.hideInformationControl();
                                    }
                                } else if (this.display != null && !this.display.isDisposed()) {
                                    this.display.removeFilter(5, (Listener)this);
                                }
                            }
                        } else if (event.type == 16 && this.informationControl != null && !this.informationControl.isFocusControl()) {
                            this.hideInformationControl();
                        }
                    }
                }
            };
            this.getInternalAccessor().setInformationControlReplacer(this.replacer);
            this.keyListener = new KeyListener(){

                public void keyReleased(KeyEvent event) {
                    IInformationControl informationControl;
                    if (event.keyCode == 0x100000B && (informationControl = this.getInformationControl()) instanceof AccessibleInformationControl) {
                        Control myControl = ((AccessibleInformationControl)informationControl).getControl();
                        Event mouseEvent = new Event();
                        mouseEvent.display = (this).ColumnViewerInformationControlToolTipSupport.this.control.getDisplay();
                        mouseEvent.widget = myControl;
                        mouseEvent.type = 4;
                        ((Listener)closer).handleEvent(mouseEvent);
                        event.doit = false;
                    }
                }

                public void keyPressed(KeyEvent event) {
                }
            };
        }

        protected void setCloser(AbstractInformationControlManager.IInformationControlCloser closer) {
            this.closer = closer;
            super.setCloser(closer);
        }

        protected boolean canClearDataOnHide() {
            return false;
        }

        protected void computeInformation() {
            MouseEvent hoverEvent = this.getHoverEvent();
            Event event = new Event();
            event.x = hoverEvent.x;
            event.y = hoverEvent.y;
            if (ColumnViewerInformationControlToolTipSupport.this.shouldCreateToolTip(event)) {
                StringBuffer buffer = new StringBuffer(ColumnViewerInformationControlToolTipSupport.this.text);
                String styleSheet = ColumnViewerInformationControlToolTipSupport.this.getStyleSheet();
                FontData fontData = JFaceResources.getFontRegistry().getFontData(ColumnViewerInformationControlToolTipSupport.this.getSymbolicFont())[0];
                styleSheet = HTMLPrinter.convertTopLevelFont((String)styleSheet, (FontData)fontData);
                HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)(ColumnViewerInformationControlToolTipSupport.this.foregroundColor == null ? null : ColumnViewerInformationControlToolTipSupport.this.foregroundColor.getRGB()), ColumnViewerInformationControlToolTipSupport.this.backgroundColor == null ? null : ColumnViewerInformationControlToolTipSupport.this.backgroundColor.getRGB(), (String)styleSheet);
                HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                final String html = buffer.toString();
                this.setInformation(new BrowserInformationControlInput(null){

                    public String getHtml() {
                        return html;
                    }

                    public String getInputName() {
                        return "";
                    }

                    public Object getInputElement() {
                        return (this).ColumnViewerInformationControlToolTipSupport.this.text;
                    }
                }, ColumnViewerInformationControlToolTipSupport.this.currentCell.getBounds());
                ColumnViewerInformationControlToolTipSupport.this.currentCell = null;
            } else {
                this.setInformation(null, null);
            }
        }

        public void install(Control subjectControl) {
            Control oldSubjectControl = this.getSubjectControl();
            if (oldSubjectControl != null && !oldSubjectControl.isDisposed()) {
                oldSubjectControl.removeKeyListener(this.keyListener);
            }
            if (subjectControl != null) {
                subjectControl.addKeyListener(this.keyListener);
            }
            super.install(subjectControl);
            this.getInternalAccessor().getInformationControlReplacer().install(subjectControl);
        }

        public void dispose() {
            Control subjectControl = this.getSubjectControl();
            if (subjectControl != null && !subjectControl.isDisposed()) {
                subjectControl.removeKeyListener(this.keyListener);
            }
            this.replacer.dispose();
            super.dispose();
        }
    };

    public ColumnViewerInformationControlToolTipSupport(ColumnViewer viewer, LocationListener locationListener) {
        this.viewer = viewer;
        this.control = viewer.getControl();
        this.locationListener = locationListener == null ? new PathLocationListener((StructuredViewer)viewer) : locationListener;
        this.hoverInformationControlManager.install(this.control);
    }

    protected String getSymbolicFont() {
        if (this.font == null) {
            return DEFAULT_FONT;
        }
        Object[] fontData = this.font.getFontData();
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        for (Object name : fontRegistry.getKeySet()) {
            Object[] registerFontData = fontRegistry.getFontData((String)name);
            if (!Arrays.equals(fontData, registerFontData)) continue;
            return (String)name;
        }
        return DEFAULT_FONT;
    }

    public void showInformation() {
        this.hoverInformationControlManager.showInformation();
    }

    public void setSizeConstraints(int widthInChar, int heightInChar, boolean enforceAsMinimalSize, boolean enforceAsMaximalSize) {
        this.hoverInformationControlManager.setSizeConstraints(widthInChar, heightInChar, enforceAsMinimalSize, enforceAsMaximalSize);
    }

    public String getStyleSheet() {
        URL styleSheetURL;
        if (defaultStyleSheet == null && (styleSheetURL = CommonUIPlugin.getPlugin().getBundle().getEntry("EMFCommonUIHoverStyleSheet.css")) != null) {
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                    StringBuffer buffer = new StringBuffer(1500);
                    String line = reader.readLine();
                    while (line != null) {
                        buffer.append(line);
                        buffer.append('\n');
                        line = reader.readLine();
                    }
                    defaultStyleSheet = buffer.toString();
                }
                catch (IOException ex) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return "";
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return defaultStyleSheet;
    }

    protected void toolTipShow(Shell tip, Event event) {
        if (!tip.isDisposed()) {
            this.currentCell = this.getToolTipArea(event);
            tip.setVisible(true);
        }
    }

    protected ViewerCell getToolTipArea(Event event) {
        return this.viewer.getCell(new Point(event.x, event.y));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean shouldCreateToolTip(Event event) {
        ViewerCell cell = this.getToolTipArea(event);
        if (cell != null && !cell.equals((Object)this.currentCell)) {
            this.control.setToolTipText("");
            this.currentCell = cell;
            ViewerRow row = cell.getViewerRow();
            if (row == null) return false;
            Object element = row.getItem().getData();
            CellLabelProvider labelProvider = this.viewer.getLabelProvider(cell.getColumnIndex());
            this.text = labelProvider.getToolTipText(element);
            boolean useNative = labelProvider.useNativeToolTip(element);
            if (!useNative && this.text != null) {
                this.foregroundColor = labelProvider.getToolTipForegroundColor(element);
                this.backgroundColor = labelProvider.getToolTipBackgroundColor(element);
                this.font = labelProvider.getToolTipFont(element);
                if (this.text == null) return false;
                return true;
            }
            this.control.setToolTipText(this.text);
            return false;
        }
        this.currentCell = cell;
        return false;
    }

    public void dispose() {
        this.hoverInformationControlManager.dispose();
    }

    public static interface AccessibleInformationControl
    extends IInformationControl,
    IInformationControlExtension,
    IInformationControlExtension2,
    IInformationControlExtension3,
    IInformationControlExtension4,
    IInformationControlExtension5 {
        public Control getControl();
    }

    public static class PathLocationListener
    implements LocationListener {
        protected StructuredViewer viewer;

        public PathLocationListener(StructuredViewer viewer) {
            this.viewer = viewer;
        }

        public URI getURI(Object object) {
            IContentProvider contentProvider = this.viewer.getContentProvider();
            if (contentProvider instanceof IStructuredContentProvider) {
                IStructuredContentProvider structuredContentProvider = (IStructuredContentProvider)contentProvider;
                List<Object> elements = Arrays.asList(structuredContentProvider.getElements(this.viewer.getInput()));
                if (structuredContentProvider instanceof ITreeContentProvider) {
                    return this.traverse(elements, (ITreeContentProvider)structuredContentProvider, object);
                }
                int index = elements.indexOf(object);
                if (index != -1) {
                    return URI.createURI((String)("path:/" + index));
                }
            }
            return null;
        }

        protected URI traverse(List<Object> elements, ITreeContentProvider treeContentProvider, Object object) {
            List<Object> children;
            URI uri;
            int index = elements.indexOf(object);
            if (index != -1) {
                return URI.createURI((String)("path:/" + index));
            }
            Object parent = treeContentProvider.getParent(object);
            if (parent != null && (uri = this.traverse(elements, treeContentProvider, parent)) != null && (index = (children = Arrays.asList(treeContentProvider.getChildren(parent))).indexOf(object)) != -1) {
                return uri.appendSegment(Integer.toString(index));
            }
            return null;
        }

        public void changing(LocationEvent event) {
            URI uri = URI.createURI((String)event.location);
            if ("path".equals(uri.scheme())) {
                IContentProvider contentProvider = this.viewer.getContentProvider();
                if (contentProvider instanceof IStructuredContentProvider) {
                    IStructuredContentProvider structuredContentProvider = (IStructuredContentProvider)contentProvider;
                    this.traverse(structuredContentProvider, uri.segments(), 0);
                }
                event.doit = false;
            }
        }

        protected void traverse(IStructuredContentProvider structuredContentProvider, String[] segments, int index) {
            Object[] elements = structuredContentProvider.getElements(this.viewer.getInput());
            int i = Integer.parseInt(segments[index++]);
            Object object = elements[i];
            if (index != segments.length && structuredContentProvider instanceof ITreeContentProvider) {
                ITreeContentProvider treeContentProvider = (ITreeContentProvider)structuredContentProvider;
                this.traverse(treeContentProvider, object, segments, index);
            } else {
                this.setSelection(object);
            }
        }

        protected void traverse(ITreeContentProvider treeContentProvider, Object object, String[] segments, int index) {
            Object[] children = treeContentProvider.getChildren(object);
            int i = Integer.parseInt(segments[index++]);
            Object child = children[i];
            if (index != segments.length) {
                this.traverse(treeContentProvider, child, segments, index);
            } else {
                this.setSelection(child);
            }
        }

        protected void setSelection(Object object) {
            this.viewer.setSelection((ISelection)new StructuredSelection(object), true);
            this.viewer.getControl().setFocus();
        }

        public void changed(LocationEvent event) {
        }
    }
}

