/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.util.ArchiveResourceImpl;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.PGPKeyResourceImpl;
import org.eclipse.oomph.p2.internal.core.X509CertificateResourceImpl;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;

public class IndexManager {
    private static URI DEFAULT_INDEX_LOCATION = URI.createURI((String)"archive:https://www.eclipse.org/setups/setups.zip!/https/raw.githubusercontent.com/eclipse-oomph/oomph/master/setups/org.eclipse.setup");
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private final URI indicesLocation;
    private final Resource indicesResource;
    private final IndexManager globalIndexManager;

    public IndexManager() {
        this(SetupContext.CONFIGURATION_STATE_LOCATION_URI.appendSegment("indices.xmi"), new IndexManager(SetupContext.GLOBAL_SETUPS_LOCATION_URI.appendSegment("indices.xmi"), null));
    }

    private IndexManager(URI indicesLocation, IndexManager globalIndexManager) {
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new BaseResourceFactoryImpl());
        this.indicesLocation = indicesLocation;
        this.indicesResource = this.resourceSet.createResource(indicesLocation);
        this.globalIndexManager = globalIndexManager;
    }

    public IndexManager getGlobalIndexManager() {
        return this.globalIndexManager;
    }

    public boolean addIndex(Index index) {
        Resource resource = index.eResource();
        URI uri = resource.getURI();
        URIConverter uriConverter = resource.getResourceSet().getURIConverter();
        URI indexLocation = uriConverter.normalize(uri);
        IndexManager.handleTrust(index);
        return this.addIndex(indexLocation, index.getName(), false);
    }

    public boolean addIndex(URI indexLocation, String name, boolean local) {
        if (!local && this.globalIndexManager != null) {
            this.globalIndexManager.addIndex(indexLocation, name, true);
        }
        Annotation annotation = this.getAnnotation();
        EMap details = annotation.getDetails();
        String oldName = (String)details.put((Object)indexLocation.toString(), (Object)name);
        int entryIndex = details.indexOfKey((Object)indexLocation.toString());
        if (entryIndex != 0) {
            details.move(0, entryIndex);
        }
        this.save(annotation);
        return !ObjectUtil.equals((Object)oldName, (Object)name);
    }

    public void remove(URI indexLocation, boolean local) {
        if (!local && this.globalIndexManager != null) {
            this.globalIndexManager.remove(indexLocation, true);
        }
        Annotation annotation = this.getAnnotation();
        Annotation labelsAnnotation = annotation.getAnnotation("labels");
        annotation.getDetails().removeKey((Object)indexLocation.toString());
        if (labelsAnnotation != null) {
            labelsAnnotation.getDetails().removeKey((Object)indexLocation.toString());
        }
        this.save(annotation);
    }

    public void setLabel(URI indexLocation, String label, boolean local) {
        Annotation annotation;
        Annotation labelsAnnotation;
        if (!local && this.globalIndexManager != null) {
            this.globalIndexManager.setLabel(indexLocation, label, true);
        }
        if ((labelsAnnotation = (annotation = this.getAnnotation()).getAnnotation("labels")) == null) {
            labelsAnnotation = BaseFactory.eINSTANCE.createAnnotation();
            labelsAnnotation.setSource("labels");
            annotation.getAnnotations().add((Object)labelsAnnotation);
        }
        labelsAnnotation.getDetails().put((Object)indexLocation.toString(), (Object)label);
        this.save(annotation);
    }

    public void configure(ResourceSet resourceSet) {
        URI indexLocation;
        Annotation annotation;
        EMap details;
        URI currentIndexLocation;
        if (StringUtil.isEmpty((String)PropertiesUtil.getProperty((String)"oomph.setup.product.catalog.filter")) && StringUtil.isEmpty((String)PropertiesUtil.getProperty((String)"oomph.setup.product.filter")) && StringUtil.isEmpty((String)PropertiesUtil.getProperty((String)"oomph.setup.product.version.filter")) && ((currentIndexLocation = resourceSet.getURIConverter().normalize(SetupContext.INDEX_SETUP_URI)).equals(DEFAULT_INDEX_LOCATION) || currentIndexLocation.equals(SetupContext.INDEX_SETUP_LOCATION_URI)) && !(details = (annotation = this.getAnnotation()).getDetails()).isEmpty() && (!(indexLocation = URI.createURI((String)((String)((Map.Entry)details.get(0)).getKey()))).equals(DEFAULT_INDEX_LOCATION) && currentIndexLocation.equals(SetupContext.INDEX_SETUP_LOCATION_URI) || details.containsKey((Object)currentIndexLocation.toString()) && !currentIndexLocation.equals(indexLocation))) {
            this.configureForProxy(resourceSet, indexLocation);
        }
    }

    public void configureForProxy(ResourceSet resourceSet, URI indexLocation) {
        if (indexLocation.isArchive()) {
            String authority = indexLocation.authority();
            URI archiveLocation = URI.createURI((String)authority.substring(0, authority.length() - 1));
            this.configure(resourceSet, archiveLocation);
        } else {
            this.configure(resourceSet, SetupContext.INDEX_SETUP_ARCHIVE_LOCATION_URI);
            Map uriMap = resourceSet.getURIConverter().getURIMap();
            uriMap.put(SetupContext.INDEX_ROOT_URI, indexLocation.trimSegments(1).appendSegment(""));
        }
    }

    public void configure(ResourceSet resourceSet, URI setupArchiveURI) {
        ArchiveResourceImpl archiveResource = new ArchiveResourceImpl(setupArchiveURI, resourceSet.getURIConverter());
        try {
            archiveResource.load(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Annotation annotation = (Annotation)EcoreUtil.getObjectByType((Collection)archiveResource.getContents(), (EClassifier)BasePackage.Literals.ANNOTATION);
        if (annotation != null && !annotation.getDetails().isEmpty()) {
            URIConverter uriConverter = resourceSet.getURIConverter();
            Map uriMap = uriConverter.getURIMap();
            uriMap.clear();
            SetupCoreUtil.configureRedirections(uriMap);
            uriMap.put(SetupContext.INDEX_SETUP_ARCHIVE_LOCATION_URI, setupArchiveURI);
            boolean indexProcessed = false;
            EMap details = annotation.getDetails();
            String indexTargetURI = (String)details.get((Object)SetupContext.INDEX_SETUP_LOCATION_URI.toString());
            if (indexTargetURI != null && SetupContext.INDEX_SETUP_LOCATION_URI.equals(uriConverter.normalize(SetupContext.INDEX_SETUP_LOCATION_URI))) {
                URI targtURI = URI.createURI((String)indexTargetURI);
                uriMap.put(SetupContext.INDEX_SETUP_LOCATION_URI, targtURI);
                uriMap.put(SetupContext.INDEX_SETUP_LOCATION_URI, targtURI);
                uriMap.put(SetupContext.INDEX_ROOT_LOCATION_URI, targtURI.trimSegments(1).appendSegment(""));
                uriMap.put(SetupContext.INDEX_ROOT_URI, targtURI.trimSegments(1).appendSegment(""));
                indexProcessed = true;
            }
            for (Map.Entry entry : details) {
                URI sourceURI = URI.createURI((String)((String)entry.getKey()));
                if (!sourceURI.equals(uriConverter.normalize(sourceURI))) continue;
                URI targtURI = URI.createURI((String)((String)entry.getValue()));
                uriMap.put(sourceURI, targtURI);
                if (indexProcessed || !"org.eclipse.setup".equals(sourceURI.lastSegment())) continue;
                uriMap.put(SetupContext.INDEX_SETUP_LOCATION_URI, targtURI);
                uriMap.put(SetupContext.INDEX_ROOT_LOCATION_URI, targtURI.trimSegments(1).appendSegment(""));
                uriMap.put(SetupContext.INDEX_ROOT_URI, targtURI.trimSegments(1).appendSegment(""));
            }
        }
    }

    public Map<URI, String> getIndexNames(boolean local) {
        LinkedHashMap<URI, String> result = new LinkedHashMap<URI, String>();
        Annotation annotation = this.getAnnotation();
        for (Map.Entry detail : annotation.getDetails()) {
            String name = (String)detail.getValue();
            if (StringUtil.isEmpty((String)name)) {
                name = "<unnamed-index>";
            }
            result.put(URI.createURI((String)((String)detail.getKey())), name);
        }
        if (!local && this.globalIndexManager != null) {
            for (Map.Entry<URI, String> entry : this.globalIndexManager.getIndexNames(true).entrySet()) {
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public Map<URI, String> getIndexLabels(boolean local) {
        Annotation annotation = this.getAnnotation();
        Annotation labelsAnnotation = annotation.getAnnotation("labels");
        LinkedHashMap<URI, String> result = new LinkedHashMap<URI, String>();
        HashSet<String> labels = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry detail : annotation.getDetails()) {
            String name;
            String label = null;
            String indexLocation = (String)detail.getKey();
            if (labelsAnnotation != null) {
                label = (String)labelsAnnotation.getDetails().get((Object)indexLocation);
            }
            if (label == null && !labels.add(name = (String)detail.getValue())) {
                duplicates.add(name);
            }
            result.put(URI.createURI((String)indexLocation), label);
        }
        for (Map.Entry detail : annotation.getDetails()) {
            URI indexLocation = URI.createURI((String)((String)detail.getKey()));
            if (result.get(indexLocation) != null) continue;
            Object itemText = (String)detail.getValue();
            if (StringUtil.isEmpty((String)itemText)) {
                itemText = "<unnamed-index>";
            }
            if (duplicates.contains(itemText)) {
                itemText = (String)itemText + " - " + String.valueOf(indexLocation);
            }
            result.put(indexLocation, (String)itemText);
        }
        if (!local && this.globalIndexManager != null) {
            for (Map.Entry<URI, String> entry : this.globalIndexManager.getIndexLabels(true).entrySet()) {
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public Map<URI, Boolean> getIndexAvailability(boolean local) {
        LinkedHashMap<URI, Boolean> result = new LinkedHashMap<URI, Boolean>();
        Set<URI> indexLocations = this.getIndexNames(local).keySet();
        URIConverter uriConverter = this.resourceSet.getURIConverter();
        for (URI indexLocation : indexLocations) {
            result.put(indexLocation, uriConverter.exists(indexLocation, null));
        }
        return result;
    }

    private Annotation getAnnotation() {
        BaseUtil.execute((long)5000L, (Runnable)new Runnable(){

            @Override
            public void run() {
                IndexManager.this.loadIndices();
            }
        }, (URIConverter)this.resourceSet.getURIConverter(), (URI[])new URI[]{this.indicesLocation});
        Annotation annotation = (Annotation)EcoreUtil.getObjectByType((Collection)this.indicesResource.getContents(), (EClassifier)BasePackage.Literals.ANNOTATION);
        if (annotation == null) {
            annotation = this.createDefaultIndex();
        }
        return annotation;
    }

    private void loadIndices() {
        if (this.resourceSet.getURIConverter().exists(this.indicesLocation, null)) {
            try {
                this.indicesResource.unload();
                this.indicesResource.load(this.resourceSet.getLoadOptions());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Annotation annotation = (Annotation)EcoreUtil.getObjectByType((Collection)this.indicesResource.getContents(), (EClassifier)BasePackage.Literals.ANNOTATION);
            if (annotation == null) {
                this.createDefaultIndex();
            }
        } else {
            this.createDefaultIndex();
        }
    }

    private Annotation createDefaultIndex() {
        Annotation annotation = null;
        if (this.globalIndexManager != null && (annotation = this.globalIndexManager.getAnnotation()) != null) {
            annotation = (Annotation)EcoreUtil.copy((EObject)annotation);
        }
        if (annotation == null) {
            ResourceSet configuredResourceSet = SetupCoreUtil.createResourceSet();
            URI indexLocation = configuredResourceSet.getURIConverter().normalize(SetupContext.INDEX_SETUP_URI);
            annotation = BaseFactory.eINSTANCE.createAnnotation();
            annotation.setSource("IndexLocations");
            EMap details = annotation.getDetails();
            details.put((Object)indexLocation.toString(), (Object)"Eclipse");
        }
        EList contents = this.indicesResource.getContents();
        contents.clear();
        contents.add((Object)annotation);
        return annotation;
    }

    private void save(final Annotation annotation) {
        BaseUtil.execute((long)5000L, (Runnable)new Runnable(){

            @Override
            public void run() {
                BaseUtil.saveEObject((EObject)annotation);
            }
        }, (URIConverter)this.resourceSet.getURIConverter(), (URI[])new URI[]{this.indicesLocation});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleTrust(Index index) {
        try {
            IInstallableUnit contextIU = null;
            PGPPublicKeyService keyService = null;
            for (Annotation annotation : index.getAnnotations()) {
                Profile profile;
                Resource resource;
                String source = annotation.getSource();
                boolean trustedKeysAnnotation = "http://www.eclipse.org/oomph/setup/TrustedKeys".equals(source);
                boolean trustedCertificatesAnnotation = "http://www.eclipse.org/oomph/setup/TrustedCertificates".equals(source);
                if (!trustedKeysAnnotation && !trustedCertificatesAnnotation) continue;
                IMatchExpression<IInstallableUnit> filter = IndexManager.getFilter(annotation);
                if (filter != null) {
                    if (contextIU == null) {
                        LinkedHashMap<String, String> safeProperties = new LinkedHashMap<String, String>();
                        Properties properties = System.getProperties();
                        Properties properties2 = properties;
                        synchronized (properties2) {
                            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                                Object key = entry.getKey();
                                Object value = entry.getValue();
                                if (key == null || value == null) continue;
                                safeProperties.put(key.toString(), value.toString());
                            }
                        }
                        contextIU = InstallableUnit.contextIU(safeProperties);
                    }
                    if (!filter.isMatch(contextIU)) continue;
                }
                if (trustedKeysAnnotation) {
                    if (keyService == null) {
                        keyService = (PGPPublicKeyService)P2Util.getCurrentProvisioningAgent().getService(PGPPublicKeyService.class);
                    }
                    LinkedHashSet<PGPPublicKey> keys = new LinkedHashSet<PGPPublicKey>();
                    for (EObject eObject : annotation.getReferences()) {
                        resource = eObject.eResource();
                        if (!(resource instanceof PGPKeyResourceImpl)) continue;
                        for (PGPPublicKey key : ((PGPKeyResourceImpl)resource).getPublicKeys()) {
                            keys.add(keyService.addKey(key));
                        }
                    }
                    if (keys.isEmpty() || (profile = P2Util.getAgentManager().getCurrentAgent().getCurrentProfile()) == null) continue;
                    P2Util.addedTrustedKeys((Profile)profile, keys);
                    continue;
                }
                if (!trustedCertificatesAnnotation) continue;
                LinkedHashSet<Certificate> certificates = new LinkedHashSet<Certificate>();
                for (EObject eObject : annotation.getReferences()) {
                    resource = eObject.eResource();
                    if (!(resource instanceof X509CertificateResourceImpl)) continue;
                    certificates.add(((X509CertificateResourceImpl)resource).getCertificate());
                }
                if (certificates.isEmpty() || (profile = P2Util.getAgentManager().getCurrentAgent().getCurrentProfile()) == null) continue;
                P2Util.addedTrustedCertificates((Profile)profile, certificates);
            }
        }
        catch (Exception ex) {
            SetupCorePlugin.INSTANCE.log(ex);
        }
    }

    private static IMatchExpression<IInstallableUnit> getFilter(Annotation annotation) {
        String filter = (String)annotation.getDetails().get((Object)"filter");
        if (!StringUtil.isEmpty((String)filter)) {
            try {
                IMatchExpression matchExpression = InstallableUnit.parseFilter((String)filter);
                return matchExpression;
            }
            catch (Exception ex) {
                SetupCorePlugin.INSTANCE.log(ex);
            }
        }
        return null;
    }

    public static URI getUnderlyingLocation(URI indexLocation) {
        if (indexLocation.isArchive()) {
            String authority = indexLocation.authority();
            return URI.createURI((String)authority.substring(0, authority.length() - 1));
        }
        if ("org.eclipse.setup".equals(indexLocation.lastSegment())) {
            return indexLocation.trimSegments(1).appendSegment("");
        }
        return indexLocation;
    }
}

