/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.keys;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.KeyAssistDialog;
import org.eclipse.e4.ui.bindings.keys.OutOfOrderListener;
import org.eclipse.e4.ui.bindings.keys.OutOfOrderVerifyListener;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class KeyBindingDispatcher {
    private KeyAssistDialog keyAssistDialog;
    private IContributionFactory contributionFactory;
    static KeySequence outOfOrderKeys;
    private static final int DELAY = 1000;
    private EBindingService bindingService;
    private IEclipseContext context;
    private EHandlerService handlerService;
    private final KeyDownFilter keyDownFilter = new KeyDownFilter();
    private final OutOfOrderListener outOfOrderListener = new OutOfOrderListener(this);
    private final OutOfOrderVerifyListener outOfOrderVerifyListener = new OutOfOrderVerifyListener(this.outOfOrderListener);
    private KeySequence state = KeySequence.getInstance();
    private long startTime;
    @Inject
    @Optional
    private Logger logger;

    static {
        try {
            outOfOrderKeys = KeySequence.getInstance((String)"ESC DEL");
        }
        catch (ParseException e) {
            outOfOrderKeys = KeySequence.getInstance();
        }
    }

    public static List<KeyStroke> generatePossibleKeyStrokes(Event event) {
        int thirdAccelerator;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return keyStrokes;
        }
        int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
        keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)firstAccelerator));
        if (event.character == '\u007f') {
            return keyStrokes;
        }
        int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
        if (secondAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)secondAccelerator));
        }
        if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)thirdAccelerator));
        }
        return keyStrokes;
    }

    private static boolean isOutOfOrderKey(List<KeyStroke> keyStrokes) {
        KeyStroke[] outOfOrderKeyStrokes = outOfOrderKeys.getKeyStrokes();
        int outOfOrderKeyStrokesLength = outOfOrderKeyStrokes.length;
        int i = 0;
        while (i < outOfOrderKeyStrokesLength) {
            if (keyStrokes.contains(outOfOrderKeyStrokes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean executeCommand(ParameterizedCommand parameterizedCommand, Event trigger) throws CommandException {
        this.resetState(false);
        if (!this.isActive(parameterizedCommand)) {
            throw new NotEnabledException("Command should have been disabled via activity: " + String.valueOf(parameterizedCommand));
        }
        EHandlerService handlerService = this.getHandlerService();
        Command command = parameterizedCommand.getCommand();
        IEclipseContext staticContext = this.createContext(trigger);
        boolean commandDefined = command.isDefined();
        boolean commandHandled = false;
        try {
            Object obj = HandlerServiceImpl.lookUpHandler((IEclipseContext)this.context, (String)command.getId());
            if (obj != null) {
                commandHandled = obj instanceof IHandler ? ((IHandler)obj).isHandled() : true;
            }
            if (this.isTracingEnabled()) {
                this.logger.trace("Command " + String.valueOf(parameterizedCommand) + ", defined: " + commandDefined + ", handled: " + commandHandled + " in " + this.describe(this.context));
            }
            handlerService.executeHandler(parameterizedCommand, staticContext);
            Object commandException = staticContext.get("HandlerServiceImpl.exception");
            if (commandException instanceof CommandException) {
                commandHandled = false;
                if (commandException instanceof ExecutionException) {
                    if (this.logger != null) {
                        this.logger.error((Throwable)commandException, "Execution exception for: " + String.valueOf(parameterizedCommand) + " in " + this.describe(this.context));
                    }
                } else if (this.isTracingEnabled()) {
                    Set activeContextIds;
                    ContextManager contextManager;
                    HandlerServiceImpl serviceImpl;
                    IEclipseContext serviceContext;
                    this.logger.trace((Throwable)commandException, "Command exception for: " + String.valueOf(parameterizedCommand) + " in " + this.describe(this.context));
                    if (handlerService instanceof HandlerServiceImpl && (serviceContext = (serviceImpl = (HandlerServiceImpl)handlerService).getContext()) != null) {
                        StringBuilder sb = new StringBuilder("\n\tExecution context: ");
                        sb.append(this.describe(serviceContext));
                        sb.append("\n\tHandler: ");
                        sb.append(obj);
                        this.logger.trace(sb.toString());
                    }
                    if ((contextManager = (ContextManager)this.context.get(ContextManager.class)) != null && (activeContextIds = contextManager.getActiveContextIds()) != null && !activeContextIds.isEmpty()) {
                        StringBuilder sb = new StringBuilder("\n\tAll active contexts: ");
                        sb.append(activeContextIds);
                        this.logger.trace(sb.toString());
                    }
                }
            }
            if (this.keyAssistDialog != null) {
                this.keyAssistDialog.clearRememberedState();
            }
        }
        finally {
            staticContext.dispose();
        }
        return commandDefined && commandHandled;
    }

    private boolean isTracingEnabled() {
        return this.logger != null && this.logger.isTraceEnabled();
    }

    private IEclipseContext createContext(Event trigger) {
        IEclipseContext staticContext = EclipseContextFactory.create((String)"keys-staticContext");
        staticContext.set(Event.class, (Object)trigger);
        return staticContext;
    }

    private void filterKeySequenceBindings(Event event) {
        if ((event.keyCode & SWT.MODIFIER_MASK) != 0) {
            return;
        }
        List<KeyStroke> keyStrokes = KeyBindingDispatcher.generatePossibleKeyStrokes(event);
        if (KeyBindingDispatcher.isOutOfOrderKey(keyStrokes)) {
            if (this.isTracingEnabled()) {
                this.logger.trace("Out of order key: " + String.valueOf(keyStrokes) + " in " + this.describe(this.context));
            }
            Widget widget = event.widget;
            if (event.character == '\u007f' && (event.stateMask & SWT.MODIFIER_MASK) == 0 && (widget instanceof Text || widget instanceof Combo || widget instanceof Browser || widget instanceof CCombo)) {
                return;
            }
            if (widget instanceof StyledText) {
                if (event.type == 1 && !this.outOfOrderVerifyListener.isActive(event.time)) {
                    ((StyledText)widget).addVerifyKeyListener((VerifyKeyListener)this.outOfOrderVerifyListener);
                    this.outOfOrderVerifyListener.setActive(event.time);
                }
            } else if (!this.outOfOrderListener.isActive(event.time)) {
                widget.addListener(1, (Listener)this.outOfOrderListener);
                this.outOfOrderListener.setActive(event.time);
            }
        } else {
            this.processKeyEvent(keyStrokes, event);
        }
    }

    private EBindingService getBindingService() {
        if (this.bindingService == null) {
            this.bindingService = (EBindingService)this.context.get(EBindingService.class);
        }
        return this.bindingService;
    }

    private EHandlerService getHandlerService() {
        if (this.handlerService == null) {
            this.handlerService = (EHandlerService)this.context.get(EHandlerService.class);
        }
        return this.handlerService;
    }

    private Display getDisplay() {
        return Display.getCurrent();
    }

    public KeyDownFilter getKeyDownFilter() {
        return this.keyDownFilter;
    }

    private void incrementState(KeySequence sequence) {
        this.state = sequence;
        long myStartTime = this.startTime = System.currentTimeMillis();
        Display display = this.getDisplay();
        display.timerExec(1000, () -> {
            if (System.currentTimeMillis() > myStartTime - 1000L && this.startTime == myStartTime) {
                Collection<Binding> partialMatches = this.bindingService.getPartialMatches((TriggerSequence)sequence);
                this.openKeyAssistShell(partialMatches);
            }
        });
    }

    private final void openKeyAssistShell(Collection<Binding> bindings) {
        if (this.keyAssistDialog == null) {
            this.keyAssistDialog = new KeyAssistDialog(this.context, this);
        }
        if (this.keyAssistDialog.getShell() == null) {
            this.keyAssistDialog.setParentShell(this.getDisplay().getActiveShell());
        }
        this.keyAssistDialog.open(bindings);
    }

    private boolean isPartialMatch(KeySequence keySequence) {
        return this.getBindingService().isPartialMatch((TriggerSequence)keySequence);
    }

    private boolean isUniqueMatch(KeySequence keySequence, IEclipseContext context2) {
        return this.getExecutableMatches(keySequence, context2).size() == 1;
    }

    private Collection<Binding> getExecutableMatches(KeySequence keySequence, IEclipseContext context2) {
        Binding binding = this.getBindingService().getPerfectMatch((TriggerSequence)keySequence);
        if (binding != null) {
            return Collections.singleton(binding);
        }
        Collection<Binding> conflicts = this.getBindingService().getConflictsFor((TriggerSequence)keySequence);
        if (conflicts != null) {
            return conflicts.stream().filter(match -> this.getHandlerService().canExecute(match.getParameterizedCommand(), context2)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    /*
     * Loose catch block
     */
    public boolean press(List<KeyStroke> potentialKeyStrokes, Event event) {
        KeySequence errorSequence = null;
        Collection<Binding> errorMatch = null;
        IEclipseContext staticContext = this.createContext(event);
        KeySequence sequenceBeforeKeyStroke = this.state;
        try {
            for (KeyStroke keyStroke : potentialKeyStrokes) {
                KeySequence sequenceAfterKeyStroke = KeySequence.getInstance((KeySequence)sequenceBeforeKeyStroke, (KeyStroke)keyStroke);
                if (this.isPartialMatch(sequenceAfterKeyStroke)) {
                    this.incrementState(sequenceAfterKeyStroke);
                    if (this.isTracingEnabled()) {
                        this.logger.trace("Partial match: " + String.valueOf(sequenceAfterKeyStroke) + " in " + this.describe(this.context));
                    }
                    return true;
                }
                if (this.isUniqueMatch(sequenceAfterKeyStroke, staticContext)) {
                    Collection<Binding> executableMatches = this.getExecutableMatches(sequenceAfterKeyStroke, staticContext);
                    ParameterizedCommand cmd = executableMatches.iterator().next().getParameterizedCommand();
                    try {
                        boolean bl = this.executeCommand(cmd, event) || !sequenceBeforeKeyStroke.isEmpty();
                        return bl;
                    }
                    catch (CommandException e) {
                        block20: {
                            if (!this.isTracingEnabled()) break block20;
                            this.logger.trace((Throwable)e, "Can't happen in " + this.describe(this.context));
                        }
                        staticContext.dispose();
                        return true;
                    }
                }
                if (this.keyAssistDialog != null && this.keyAssistDialog.getShell() != null && (event.keyCode == 0x1000002 || event.keyCode == 0x1000001 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || event.keyCode == 13 || event.keyCode == 0x1000005 || event.keyCode == 0x1000006)) {
                    if (this.isTracingEnabled()) {
                        this.logger.trace("No execution due key assist: " + String.valueOf(sequenceAfterKeyStroke) + " in " + this.describe(this.context));
                    }
                    return false;
                }
                Collection<Binding> errorMatches = this.getExecutableMatches(sequenceAfterKeyStroke, staticContext);
                if (!errorMatches.isEmpty()) {
                    errorSequence = sequenceAfterKeyStroke;
                    errorMatch = errorMatches;
                    if (this.isTracingEnabled()) {
                        this.logger.trace("Error matches for key: " + String.valueOf(sequenceAfterKeyStroke) + ", :" + String.valueOf(errorMatches));
                    }
                    if (!sequenceBeforeKeyStroke.isEmpty() || this.keyAssistDialog == null || !this.keyAssistDialog.isShowingBindings(errorMatches)) continue;
                    if (this.isTracingEnabled()) {
                        this.logger.trace("Key assist dialog is already showing error matches: " + String.valueOf(errorMatches));
                    }
                    return false;
                }
                if (!this.isTracingEnabled() || Character.isLetterOrDigit(event.character)) continue;
                this.logger.trace("No binding for keys: " + String.valueOf(sequenceBeforeKeyStroke) + " " + String.valueOf(sequenceAfterKeyStroke) + " in " + this.describe(this.context));
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            staticContext.dispose();
        }
        this.resetState(true);
        if (sequenceBeforeKeyStroke.isEmpty() && errorSequence != null) {
            this.openKeyAssistShell(errorMatch);
        }
        return !sequenceBeforeKeyStroke.isEmpty();
    }

    private boolean isActive(ParameterizedCommand command) {
        String identifierId = command.getId();
        boolean enabled = this.contributionFactory.isEnabled(identifierId);
        return enabled;
    }

    void processKeyEvent(List<KeyStroke> keyStrokes, Event event) {
        boolean eatKey = false;
        if (!keyStrokes.isEmpty()) {
            eatKey = this.press(keyStrokes, event);
            if (this.isTracingEnabled() && !Character.isLetterOrDigit(event.character)) {
                if (eatKey) {
                    this.logger.trace("Event processing done for: " + String.valueOf(keyStrokes) + " in " + this.describe(this.context));
                } else {
                    this.logger.trace("Event processing forwarded for: " + String.valueOf(keyStrokes) + " in " + this.describe(this.context));
                }
            }
        }
        if (eatKey) {
            switch (event.type) {
                case 1: {
                    event.doit = false;
                    break;
                }
                case 31: {
                    event.detail = 0;
                    event.doit = true;
                }
            }
            event.type = 0;
        }
    }

    public void resetState() {
        this.resetState(true);
    }

    private void resetState(boolean clearRememberedState) {
        this.startTime = Long.MAX_VALUE;
        this.state = KeySequence.getInstance();
        this.closeMultiKeyAssistShell();
        if (this.keyAssistDialog != null && clearRememberedState) {
            this.keyAssistDialog.clearRememberedState();
        }
    }

    public final KeySequence getBuffer() {
        return this.state;
    }

    @Inject
    public void setContext(IEclipseContext context) {
        this.context = context;
        this.contributionFactory = (IContributionFactory)context.get(IContributionFactory.class);
    }

    private void closeMultiKeyAssistShell() {
        Shell shell;
        if (this.keyAssistDialog != null && (shell = this.keyAssistDialog.getShell()) != null && !shell.isDisposed() && shell.isVisible()) {
            this.keyAssistDialog.close(true);
        }
    }

    private String describe(IEclipseContext context) {
        StringBuilder sb = new StringBuilder("\n\tcontext chain: ");
        IEclipseContext activeContext = context;
        IEclipseContext child = context.getActiveChild();
        while (child != null) {
            sb.append(activeContext).append(" -> ");
            activeContext = child;
            child = child.getActiveChild();
        }
        sb.append(activeContext);
        return sb.toString();
    }

    public final class KeyDownFilter
    implements Listener {
        private transient boolean enabled = true;

        public final void handleEvent(Event event) {
            if (!this.enabled) {
                if (KeyBindingDispatcher.this.isTracingEnabled()) {
                    KeyBindingDispatcher.this.logger.trace("KeyBindingDispatcher is DISABLED in all contexts!");
                }
                return;
            }
            KeyBindingDispatcher.this.filterKeySequenceBindings(event);
        }

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean enabled) {
            boolean oldState = this.enabled;
            this.enabled = enabled;
            if (oldState && !enabled && KeyBindingDispatcher.this.isTracingEnabled()) {
                KeyBindingDispatcher.this.logger.trace((Throwable)new Exception("Probably illegal method call (except for very few cases)"), "KeyBindingDispatcher is DISABLED!");
            }
            if (!oldState && enabled && KeyBindingDispatcher.this.isTracingEnabled()) {
                KeyBindingDispatcher.this.logger.trace("KeyBindingDispatcher is ENABLED!");
            }
        }
    }
}

