/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.help;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.internal.commands.util.Util;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.commands.internal.ICommandHelpService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.ui.internal.handlers.E4HandlerProxy;

public class CommandHelpServiceImpl
implements ICommandHelpService {
    @Inject
    private ECommandService commandService;
    @Inject
    @Optional
    private Logger logger;
    private final Map<IHandler, String> helpContextIdsByHandler = new WeakHashMap<IHandler, String>();

    public String getHelpContextId(String commandId, IEclipseContext context) {
        if (commandId == null || context == null) {
            return null;
        }
        Command command = this.commandService.getCommand(commandId);
        if (!command.isDefined()) {
            if (this.logger != null) {
                this.logger.error("The command " + commandId + " is not defined. Help context ID cannot be determined.");
            }
            return null;
        }
        IHandler handler = null;
        Object obj = HandlerServiceImpl.lookUpHandler((IEclipseContext)context, (String)commandId);
        if (obj instanceof IHandler) {
            handler = (IHandler)obj;
        }
        if (handler instanceof E4HandlerProxy) {
            handler = ((E4HandlerProxy)handler).getHandler();
        }
        String contextId = null;
        if (handler != null) {
            contextId = this.helpContextIdsByHandler.get(handler);
        }
        if (contextId == null) {
            contextId = Util.getHelpContextId((Command)command);
        }
        return contextId;
    }

    public void setHelpContextId(IHandler handler, String contextId) {
        this.helpContextIdsByHandler.put(handler, contextId);
    }
}

