/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <K, V> Set<V> getSet(Map<K, Set<V>> map, K key) {
        Set<V> set = map.get(key);
        if (set == null) {
            set = new LinkedHashSet<V>();
            map.put(key, set);
        }
        return set;
    }

    public static <K, V> boolean add(Map<K, Set<V>> map, K key, V value) {
        Set<V> set = CollectionUtil.getSet(map, key);
        return set.add(value);
    }

    public static <K, V> boolean addAll(Map<K, Set<V>> map, K key, Collection<? extends V> values) {
        Set<V> set = CollectionUtil.getSet(map, key);
        return set.addAll(values);
    }

    public static <K, V> boolean addAll(Map<K, Set<V>> map, Collection<? extends K> keys, V value) {
        boolean result = false;
        for (K key : keys) {
            if (!CollectionUtil.add(map, key, value)) continue;
            result = true;
        }
        return result;
    }

    public static <K, V> boolean addAll(Map<K, Set<V>> map, Map<? extends K, ? extends Collection<? extends V>> map2) {
        boolean result = false;
        for (Map.Entry<K, Collection<V>> entry : map2.entrySet()) {
            if (!CollectionUtil.addAll(map, entry.getKey(), entry.getValue())) continue;
            result = true;
        }
        return result;
    }

    public static <K, V> boolean putAll(Map<K, Set<V>> map, Map<? extends K, ? extends V> map2) {
        boolean result = false;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (!CollectionUtil.add(map, entry.getKey(), entry.getValue())) continue;
            result = true;
        }
        return result;
    }
}

