/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.segmenter;

import com.ibm.icu.segmenter.Segment;
import com.ibm.icu.segmenter.Segments;
import com.ibm.icu.text.BreakIterator;
import java.util.Iterator;

class SegmentIterator
implements Iterator<Segment> {
    private BreakIterator breakIter;
    private final Segments.IterationDirection direction;
    private int start;
    private int limit;
    private final CharSequence source;

    SegmentIterator(BreakIterator breakIter, Segments.IterationDirection direction, int startIdx, CharSequence source) {
        this.breakIter = breakIter;
        this.direction = direction;
        this.source = source;
        boolean startIdxIsBoundary = breakIter.isBoundary(startIdx);
        if (direction == Segments.IterationDirection.FORWARDS) {
            if (startIdxIsBoundary) {
                this.start = startIdx;
                this.limit = breakIter.next();
            } else {
                this.limit = breakIter.current();
                this.start = breakIter.previous();
                breakIter.isBoundary(this.limit);
            }
        } else {
            assert (direction == Segments.IterationDirection.BACKWARDS);
            this.limit = startIdxIsBoundary ? breakIter.current() : breakIter.previous();
            this.start = breakIter.previous();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.direction == Segments.IterationDirection.FORWARDS) {
            return this.limit != -1;
        }
        return this.start != -1;
    }

    @Override
    public Segment next() {
        Segment result = new Segment(this.start, this.limit, this.source);
        if (this.direction == Segments.IterationDirection.FORWARDS) {
            this.start = this.limit;
            this.limit = this.breakIter.next();
        } else {
            assert (this.direction == Segments.IterationDirection.BACKWARDS);
            this.limit = this.start;
            this.start = this.breakIter.previous();
        }
        return result;
    }
}

