/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.PrintWriter;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.e4.core.services.about.AboutSections;
import org.eclipse.e4.core.services.about.ISystemInformation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class ConfigurationLogDefaultSection
implements ISystemSummarySection {
    @Override
    public void write(PrintWriter writer) {
        this.appendSection("section.system.properties", WorkbenchMessages.SystemSummary_systemProperties, writer);
        this.appendSection("section.system.environment", WorkbenchMessages.SystemSummary_systemVariables, writer);
        this.appendSection("section.installed.features", WorkbenchMessages.SystemSummary_features, writer);
        this.appendSection("section.installed.bundles", WorkbenchMessages.SystemSummary_pluginRegistry, writer);
        this.appendSection("section.user.preferences", WorkbenchMessages.SystemSummary_userPreferences, writer);
    }

    private void appendSection(String section, String caption, PrintWriter writer) {
        writer.println();
        writer.println(caption);
        try {
            if (!ServiceCaller.callOnce(this.getClass(), ISystemInformation.class, (String)AboutSections.createSectionFilter((String)section), systemInformation -> systemInformation.append(writer))) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            WorkbenchPlugin.log(NLS.bind((String)"Failed to retrieve data for section: {0}", (Object)section), e);
            writer.println(WorkbenchMessages.SystemSummary_sectionError);
        }
    }
}

