/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.figures.AbstractLinearMarkedFigure;
import org.eclipse.nebula.visualization.widgets.util.GraphicsUtil;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaledMarker;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TankFigure
extends AbstractLinearMarkedFigure {
    private static final Color WHITE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private static final Color GRAY_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
    private static final Color BLUE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLUE);
    private boolean effect3D = true;
    private Tank tank;
    private Color fillColor = BLUE_COLOR;
    private Color fillBackgroundColor = GRAY_COLOR;

    public TankFigure() {
        ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.VERTICAL);
        this.scale.setScaleLineVisible(false);
        this.tank = new Tank();
        this.setLayoutManager((LayoutManager)new TankLayout());
        this.add((IFigure)this.scale, "scale");
        this.add((IFigure)this.marker, "markers");
        this.add((IFigure)this.tank, "tank");
    }

    public Color getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public boolean isEffect3D() {
        return this.effect3D;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public void setEffect3D(boolean effect3D) {
        if (this.effect3D == effect3D) {
            return;
        }
        this.effect3D = effect3D;
        this.repaint();
    }

    public void setFillBackgroundColor(Color fillBackgroundColor) {
        if (this.fillBackgroundColor != null && this.fillBackgroundColor.equals((Object)fillBackgroundColor)) {
            return;
        }
        this.fillBackgroundColor = fillBackgroundColor;
        this.repaint();
    }

    public void setFillColor(Color fillColor) {
        if (this.fillColor != null && this.fillColor.equals((Object)fillColor)) {
            return;
        }
        this.fillColor = fillColor;
        this.repaint();
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
    }

    class Tank
    extends RoundedRectangle {
        private final Color EFFECT3D_OUTLINE_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(160, 160, 160));
        private static final int DEFAULT_CORNER = 15;
        private Boolean support3d;

        public Tank() {
            this.setOutline(true);
        }

        protected void fillShape(Graphics graphics) {
            int rectWidth;
            int fill_corner = 15;
            double intersectFactor = 0.55;
            if (this.bounds.width < 30) {
                intersectFactor = 0.6;
            }
            if (fill_corner > 2 * (rectWidth = (int)((double)this.bounds.width * intersectFactor)) - (this.bounds.width - 2 * this.getLineWidth())) {
                fill_corner = 2 * rectWidth - this.bounds.width;
            }
            this.corner.height = fill_corner;
            this.corner.width = fill_corner;
            graphics.setAntialias(1);
            int valuePosition = ((LinearScale)TankFigure.this.scale).getValuePosition(TankFigure.this.getCoercedValue(), false);
            if (this.support3d == null) {
                this.support3d = GraphicsUtil.testPatternSupported(graphics);
            }
            if (TankFigure.this.effect3D && this.support3d.booleanValue()) {
                graphics.setBackgroundColor(WHITE_COLOR);
                super.fillShape(graphics);
                Rectangle leftRectangle = new Rectangle(this.bounds.x, this.bounds.y, rectWidth, this.bounds.height);
                Pattern leftGradientPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), leftRectangle.x, leftRectangle.y, leftRectangle.x + leftRectangle.width + 2, leftRectangle.y, TankFigure.this.fillBackgroundColor, 255, WHITE_COLOR, 0);
                graphics.setBackgroundPattern(leftGradientPattern);
                graphics.fillRoundRectangle(leftRectangle, this.corner.width, this.corner.height);
                Rectangle rightRectangle = new Rectangle(this.bounds.x + this.bounds.width - rectWidth, this.bounds.y, rectWidth, this.bounds.height);
                Pattern rightGradientPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), rightRectangle.x - 2, rightRectangle.y, rightRectangle.x + rightRectangle.width, rightRectangle.y, WHITE_COLOR, 0, TankFigure.this.fillBackgroundColor, 255);
                graphics.setBackgroundPattern(rightGradientPattern);
                graphics.fillRoundRectangle(rightRectangle, this.corner.width, this.corner.height);
                leftGradientPattern.dispose();
                rightGradientPattern.dispose();
                graphics.setBackgroundColor(WHITE_COLOR);
                int fillHeight = this.bounds.height - (valuePosition - this.bounds.y) - this.getLineWidth();
                if (fillHeight > 0) {
                    graphics.fillRoundRectangle(new Rectangle(this.bounds.x, valuePosition, this.bounds.width, fillHeight), fill_corner, fill_corner);
                    leftRectangle = new Rectangle(this.bounds.x, valuePosition, rectWidth, fillHeight);
                    leftGradientPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), leftRectangle.x, leftRectangle.y, leftRectangle.x + leftRectangle.width + 2, leftRectangle.y, TankFigure.this.fillColor, 255, WHITE_COLOR, 0);
                    graphics.setBackgroundPattern(leftGradientPattern);
                    graphics.fillRoundRectangle(leftRectangle, fill_corner, fill_corner);
                    rightRectangle = new Rectangle(this.bounds.x + this.bounds.width - rectWidth, valuePosition, rectWidth, fillHeight);
                    rightGradientPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), rightRectangle.x - 2, rightRectangle.y, rightRectangle.x + rightRectangle.width, rightRectangle.y, WHITE_COLOR, 0, TankFigure.this.fillColor, 255);
                    graphics.setBackgroundPattern(rightGradientPattern);
                    graphics.fillRoundRectangle(rightRectangle, fill_corner, fill_corner);
                    leftGradientPattern.dispose();
                    rightGradientPattern.dispose();
                }
                graphics.setForegroundColor(this.EFFECT3D_OUTLINE_COLOR);
            } else {
                graphics.setBackgroundColor(TankFigure.this.fillBackgroundColor);
                super.fillShape(graphics);
                graphics.setBackgroundColor(TankFigure.this.fillColor);
                graphics.fillRoundRectangle(new Rectangle(this.bounds.x + this.lineWidth, valuePosition, this.bounds.width - 2 * this.lineWidth, this.bounds.height - (valuePosition - this.bounds.y)), fill_corner, fill_corner);
            }
        }
    }

    static class TankLayout
    extends AbstractLayout {
        public static final String SCALE = "scale";
        public static final String TANK = "tank";
        public static final String MARKERS = "markers";
        private LinearScale scale;
        private LinearScaledMarker marker;
        private Tank tank;

        TankLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int w, int h) {
            Insets insets = container.getInsets();
            Dimension d = new Dimension(64, 256);
            d.expand(insets.getWidth(), insets.getHeight());
            return d;
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea();
            --area.height;
            Dimension scaleSize = new Dimension(0, 0);
            Dimension markerSize = new Dimension(0, 0);
            if (this.scale != null) {
                if (this.scale.isVisible()) {
                    scaleSize = this.scale.getPreferredSize(-1, area.height);
                    this.scale.setBounds(new Rectangle(area.x, area.y, scaleSize.width, scaleSize.height));
                } else {
                    scaleSize = this.scale.getPreferredSize(-1, area.height + 2 * this.scale.getMargin());
                    this.scale.setBounds(new Rectangle(area.x, area.y - this.scale.getMargin(), scaleSize.width, scaleSize.height));
                    scaleSize.height = 0;
                    scaleSize.width = 0;
                }
            }
            if (this.marker != null && this.marker.isVisible()) {
                markerSize = this.marker.getPreferredSize();
                this.marker.setBounds(new Rectangle(area.x + area.width - markerSize.width, this.marker.getScale().getBounds().y, markerSize.width, markerSize.height));
            }
            if (this.tank != null) {
                this.tank.setBounds(new Rectangle(area.x + scaleSize.width, this.scale.getValuePosition(this.scale.getRange().getUpper(), false), area.width - scaleSize.width - markerSize.width, this.scale.getTickLength() + this.tank.getLineWidth()));
            }
        }

        public void setConstraint(IFigure child, Object constraint) {
            if (constraint.equals(SCALE)) {
                this.scale = (LinearScale)child;
            } else if (constraint.equals(MARKERS)) {
                this.marker = (LinearScaledMarker)child;
            } else if (constraint.equals(TANK)) {
                this.tank = (Tank)child;
            }
        }
    }
}

