/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui.editor;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.commons.workbench.browser.UrlHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskUrlHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TaskUrlHyperlinkDetectorTest
extends TestCase {
    private TaskRepository repository;

    protected void setUp() throws Exception {
        this.repository = TaskTestUtil.createMockRepository();
    }

    protected IHyperlink[] detect(final String text, int start, int length) {
        TaskUrlHyperlinkDetector detector = new TaskUrlHyperlinkDetector();
        detector.setContext(new IAdaptable(){

            public <T> T getAdapter(Class<T> adapter) {
                return adapter.cast(TaskUrlHyperlinkDetectorTest.this.repository);
            }
        });
        return detector.detectHyperlinks((ITextViewer)new TextViewer(){

            public IDocument getDocument() {
                return new Document(text);
            }
        }, (IRegion)new Region(start, length), true);
    }

    public void testUrl() {
        IHyperlink[] links = this.detect("http://foo", 0, 0);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((String)"http://foo", (String)((UrlHyperlink)links[0]).getURLString());
    }

    public void testInvalidUrl() {
        IHyperlink[] links = this.detect("abc", 0, 0);
        TaskUrlHyperlinkDetectorTest.assertNull((Object)links);
        links = this.detect("", 0, 0);
        TaskUrlHyperlinkDetectorTest.assertNull((Object)links);
        links = this.detect(").", 0, 0);
        TaskUrlHyperlinkDetectorTest.assertNull((Object)links);
    }

    public void testParenthesis() {
        IHyperlink[] links = this.detect("(http://foo)", 2, 0);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((String)"http://foo", (String)((UrlHyperlink)links[0]).getURLString());
        links = this.detect("( http://foo)", 2, 0);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((String)"http://foo", (String)((UrlHyperlink)links[0]).getURLString());
        links = this.detect("( http://foo).", 2, 0);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((String)"http://foo", (String)((UrlHyperlink)links[0]).getURLString());
    }

    public void testClosingParenthesis() {
        IHyperlink[] links = this.detect("http://foo?(bar)", 0, 0);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((String)"http://foo?(bar)", (String)((UrlHyperlink)links[0]).getURLString());
        links = this.detect("(http://foo?(bar))", 0, 18);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((String)"http://foo?(bar)", (String)((UrlHyperlink)links[0]).getURLString());
        links = this.detect("http://foo?((((bar).", 0, 0);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((String)"http://foo?((((bar)", (String)((UrlHyperlink)links[0]).getURLString());
        links = this.detect("http://foo?(bar))))))))", 0, 0);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((String)"http://foo?(bar)", (String)((UrlHyperlink)links[0]).getURLString());
    }

    public void testDetectionUsingExtent() {
        IHyperlink[] hyperlinks = this.detect("aa http://www.eclipse.org test", 0, 30);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)hyperlinks.length);
    }

    public void testDetectionMultipleLinks() {
        String text = "aa http://www.eclipse.org test http://www.foo.bar/baz?one=two&three=four+five#six";
        IHyperlink[] hyperlinks = this.detect(text, 0, text.length());
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)2, (int)hyperlinks.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(3, 22), (Object)hyperlinks[0].getHyperlinkRegion());
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(31, 50), (Object)hyperlinks[1].getHyperlinkRegion());
    }

    public void testDetectionNegativeMatchOnTrailingPunctuation() {
        String text = "aa http://www.eclipse.org) http://www.eclipse.org. http://www.eclipse.org,";
        IHyperlink[] hyperlinks = this.detect(text, 0, text.length());
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)3, (int)hyperlinks.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(3, 22), (Object)hyperlinks[0].getHyperlinkRegion());
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(27, 22), (Object)hyperlinks[1].getHyperlinkRegion());
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(51, 22), (Object)hyperlinks[2].getHyperlinkRegion());
    }

    public void testDetectionMultiplelinesClosingParenthesis() {
        String text = "aa http://www.eclipse.org?foo((bar)\n\n)(http://www.eclipse.org)\nhttp://www.eclipse.org()";
        IHyperlink[] hyperlinks = this.detect(text, 0, text.length());
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)3, (int)hyperlinks.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(3, 32), (Object)hyperlinks[0].getHyperlinkRegion());
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(39, 22), (Object)hyperlinks[1].getHyperlinkRegion());
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(63, 24), (Object)hyperlinks[2].getHyperlinkRegion());
    }

    public void testDetectionMultiplelines() {
        String text = "aa http://www.eclipse.org\n\nhttp://www.eclipse.org.\nhttp://www.eclipse.org,";
        IHyperlink[] hyperlinks = this.detect(text, 0, text.length());
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)3, (int)hyperlinks.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(3, 22), (Object)hyperlinks[0].getHyperlinkRegion());
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(27, 22), (Object)hyperlinks[1].getHyperlinkRegion());
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(51, 22), (Object)hyperlinks[2].getHyperlinkRegion());
    }

    public void testDetection() {
        IHyperlink[] hyperlinks = this.detect("aa http://www.eclipse.org test", 20, 0);
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)hyperlinks.length);
    }

    public void testDetection2() {
        String text = "http://www.eclipse.org";
        IHyperlink[] hyperlinks = this.detect(text, 0, text.length());
        TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
        TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)hyperlinks.length);
        TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(0, 22), (Object)hyperlinks[0].getHyperlinkRegion());
    }

    public void testDetectionNoRepositoryRegularUrl() {
        this.repository = null;
        IHyperlink[] hyperlinks = this.detect("aa http://www.eclipse.org test", 4, 0);
        TaskUrlHyperlinkDetectorTest.assertNull((Object)hyperlinks);
    }

    public void testDetectionNoRepositoryRepositoryUrl() {
        this.repository = null;
        TaskRepository repository1 = new TaskRepository("mock", "http://repo1.test/foo");
        try {
            TasksUi.getRepositoryManager().addRepository(repository1);
            String text = "aa http://repo1.test/foo http://www.eclipse.org test";
            IHyperlink[] hyperlinks = this.detect(text, 0, text.length());
            TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
            TaskUrlHyperlinkDetectorTest.assertEquals((int)1, (int)hyperlinks.length);
            TaskUrlHyperlinkDetectorTest.assertEquals((Object)new Region(3, 21), (Object)hyperlinks[0].getHyperlinkRegion());
        }
        finally {
            TasksUiPlugin.getRepositoryManager().removeRepository(repository1);
        }
    }

    public void testDetectionNoRepositoryMultipleRepositoryUrls() {
        this.repository = null;
        TaskRepository repository1 = new TaskRepository("mock", "http://repo1.test/foo");
        TaskRepository repository2 = new TaskRepository("mock", "http://repo2.test");
        try {
            TasksUi.getRepositoryManager().addRepository(repository1);
            TasksUi.getRepositoryManager().addRepository(repository2);
            String text = "aa http://repo2.test http://repo1.test/foo http://repo1.test/bar http://www.eclipse.org test";
            IHyperlink[] hyperlinks = this.detect(text, 0, text.length());
            TaskUrlHyperlinkDetectorTest.assertNotNull((Object)hyperlinks);
            TaskUrlHyperlinkDetectorTest.assertEquals((int)2, (int)hyperlinks.length);
        }
        finally {
            TasksUiPlugin.getRepositoryManager().removeRepository(repository1);
            TasksUiPlugin.getRepositoryManager().removeRepository(repository2);
        }
    }
}

