/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui.editor;

import junit.framework.TestCase;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractHyperlinkTextPresentationManager;

public class RegionComparatorTest
extends TestCase {
    AbstractHyperlinkTextPresentationManager.RegionComparator comparator = new AbstractHyperlinkTextPresentationManager.RegionComparator();

    public void testCompareToEquals() {
        Region r1 = new Region(0, 10);
        Region r2 = new Region(0, 10);
        RegionComparatorTest.assertEquals((Object)r1, (Object)r2);
        RegionComparatorTest.assertEquals((int)0, (int)this.comparator.compare((IRegion)r1, (IRegion)r2));
    }

    public void testCompareToSameLength() {
        Region r1 = new Region(0, 10);
        Region r2 = new Region(1, 10);
        RegionComparatorTest.assertFalse((boolean)r1.equals((Object)r2));
        RegionComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((IRegion)r1, (IRegion)r2));
        RegionComparatorTest.assertEquals((int)1, (int)this.comparator.compare((IRegion)r2, (IRegion)r1));
    }

    public void testCompareToNested() {
        Region r1 = new Region(0, 10);
        Region r2 = new Region(1, 8);
        RegionComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((IRegion)r1, (IRegion)r2));
        RegionComparatorTest.assertEquals((int)1, (int)this.comparator.compare((IRegion)r2, (IRegion)r1));
    }

    public void testCompareToOverlapping() {
        Region r1 = new Region(0, 10);
        Region r2 = new Region(1, 12);
        RegionComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((IRegion)r1, (IRegion)r2));
        RegionComparatorTest.assertEquals((int)1, (int)this.comparator.compare((IRegion)r2, (IRegion)r1));
        r2 = new Region(1, 9);
        RegionComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((IRegion)r1, (IRegion)r2));
        RegionComparatorTest.assertEquals((int)1, (int)this.comparator.compare((IRegion)r2, (IRegion)r1));
    }

    public void testCompareToSameOffset() {
        Region r1 = new Region(5, 8);
        Region r2 = new Region(5, 10);
        RegionComparatorTest.assertFalse((boolean)r1.equals((Object)r2));
        RegionComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((IRegion)r1, (IRegion)r2));
        RegionComparatorTest.assertEquals((int)1, (int)this.comparator.compare((IRegion)r2, (IRegion)r1));
    }
}

