/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.creole.internal.block;

import org.eclipse.mylyn.wikitext.creole.CreoleLanguage;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class ParagraphBlock
extends Block {
    private int blockLineCount = 0;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        CreoleLanguage markupLanguage = (CreoleLanguage)this.getMarkupLanguage();
        for (Block block : markupLanguage.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount > 0) {
            this.builder.characters("\n");
        }
        ++this.blockLineCount;
        markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

