/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.ui;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.AbstractQueryPageSchema;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.QueryPageDetails;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.RepositoryQuerySchemaPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.MultiSelectionAttributeEditor;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;

public class GitlabQuerySchemaPage
extends RepositoryQuerySchemaPage {
    public GitlabQuerySchemaPage(String pageName, TaskRepository repository, IRepositoryQuery query, AbstractQueryPageSchema schema, TaskData data, QueryPageDetails pageDetails) {
        super(pageName, repository, query, schema, data, pageDetails);
    }

    private void updateTaskDataFromGroup(TaskData taskData, IRepositoryQuery query, String key) {
        TaskAttribute productAttribute = taskData.getRoot().getAttribute(key);
        productAttribute.setValues(Arrays.asList(Optional.ofNullable(query.getAttribute(key)).map(st -> st.split(",")).orElse(new String[]{""})));
    }

    protected boolean restoreState(@NonNull IRepositoryQuery query) {
        TaskData taskData = this.getTargetTaskData();
        for (String entry : this.editorMap.keySet()) {
            this.updateTaskDataFromGroup(taskData, query, entry);
        }
        this.doRefreshControls();
        return true;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        query.setUrl(this.getQueryUrl(this.getTaskRepository().getRepositoryUrl()));
        for (Map.Entry entry : this.editorMap.entrySet()) {
            if (entry.getValue() instanceof MultiSelectionAttributeEditor) {
                query.setAttribute((String)entry.getKey(), String.join((CharSequence)",", ((MultiSelectionAttributeEditor)entry.getValue()).getValues()));
                continue;
            }
            query.setAttribute((String)entry.getKey(), ((AbstractAttributeEditor)entry.getValue()).getTaskAttribute().getValue());
        }
    }

    protected void doRefreshControls() {
        for (Map.Entry entry : this.editorMap.entrySet()) {
            ((AbstractAttributeEditor)entry.getValue()).refresh();
        }
    }
}

