/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.annotations.Beta;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.builder.impl.BuildManagerAccess;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.XtextBuilder;

@Beta
public class BuilderStateDiscarder {
    public boolean forgetLastBuildState(Iterable<IProject> toUpdate, Map<String, String> builderArguments) {
        if (this.canHandleBuildFlag(builderArguments)) {
            for (IProject project : toUpdate) {
                XtextBuilder builder;
                if (!project.isAccessible() || (builder = BuildManagerAccess.findBuilder(project)) == null) continue;
                builder.requestFullBuild(IBuildFlag.FORGET_BUILD_STATE_ONLY.isSet(builderArguments));
            }
            return true;
        }
        return false;
    }

    protected boolean canHandleBuildFlag(Map<String, String> builderArguments) {
        return IBuildFlag.FORGET_BUILD_STATE_ONLY.isSet(builderArguments) || IBuildFlag.RECOVERY_BUILD.isSet(builderArguments);
    }
}

