/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.editor.syntaxcoloring;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xtext.UsedRulesFinder;

public class SemanticHighlightingCalculator
extends DefaultSemanticHighlightingCalculator {
    public static final Set<String> SPECIAL_ATTRIBUTES = Sets.newHashSet((Object[])new String[]{"name", "importedNamespace", "importURI"});
    @Inject
    private OperationCanceledManager operationCanceledManager;

    protected void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        super.doProvideHighlightingFor(resource, acceptor, cancelIndicator);
        TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        HashSet calledRules = Sets.newHashSet();
        while (iter.hasNext()) {
            INode featureNode;
            INode node;
            EObject current = (EObject)iter.next();
            if (current instanceof Grammar) {
                Grammar grammar = (Grammar)current;
                if (grammar.getRules().isEmpty()) continue;
                UsedRulesFinder usedRulesFinder = new UsedRulesFinder((Collection)calledRules);
                usedRulesFinder.compute(grammar);
                continue;
            }
            if (current instanceof AbstractRule) {
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                node = this.getFirstFeatureNode(current, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME);
                this.highlightNode(acceptor, node, new String[]{"RuleDeclaration"});
                if (current instanceof ParserRule && GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)current))) {
                    this.highlightNode(acceptor, node, new String[]{"DataTypeIndicator"});
                }
                if (calledRules.isEmpty() || calledRules.contains(current)) continue;
                this.highlightNode(acceptor, node, new String[]{"NeverCalledRule"});
                continue;
            }
            if (current instanceof TypeRef) {
                node = this.getFirstFeatureNode(current, null);
                this.highlightNode(acceptor, node, new String[]{"TypeReference"});
                continue;
            }
            if (current instanceof RuleCall) {
                ParserRule container;
                RuleCall call = (RuleCall)current;
                if (!(call.getRule() instanceof TerminalRule) && (!(call.getRule() instanceof ParserRule) || !GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)call.getRule()))) || EcoreUtil2.getContainerOfType((EObject)call, Assignment.class) != null || (container = GrammarUtil.containingParserRule((EObject)call)) == null || GrammarUtil.isDatatypeRule((ParserRule)container)) continue;
                INode node2 = this.getFirstFeatureNode((EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE);
                this.highlightNode(acceptor, node2, new String[]{"UnusedValue"});
                continue;
            }
            if (!(current instanceof Assignment)) continue;
            String feature = ((Assignment)current).getFeature();
            if (SPECIAL_ATTRIBUTES.contains(feature)) {
                featureNode = this.getFirstFeatureNode(current, (EStructuralFeature)XtextPackage.Literals.ASSIGNMENT__FEATURE);
                this.highlightNode(acceptor, featureNode, new String[]{"SpecialFeature"});
                continue;
            }
            if (!"true".equals(feature) && !"false".equals(feature)) continue;
            featureNode = this.getFirstFeatureNode(current, (EStructuralFeature)XtextPackage.Literals.ASSIGNMENT__FEATURE);
            this.highlightNode(acceptor, featureNode, new String[]{"default"});
        }
    }

    public INode getFirstFeatureNode(EObject semantic, EStructuralFeature feature) {
        if (feature == null) {
            return NodeModelUtils.findActualNodeFor((EObject)semantic);
        }
        List nodes = NodeModelUtils.findNodesForFeature((EObject)semantic, (EStructuralFeature)feature);
        if (!nodes.isEmpty()) {
            return (INode)nodes.get(0);
        }
        return null;
    }
}

