/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.common.types.xtext.ui.JdtHyperlink;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;

public abstract class AbstractHyperlinkingTest
extends AbstractEditorTest {
    @Inject
    protected IHyperlinkHelper hyperlinkHelper;
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    protected IResourceSetProvider resourceSetProvider;
    @Inject
    protected XtextDocumentUtil xtextDocumentUtil;
    protected IProject project;
    protected String c = "<|>";

    public void hasHyperlinkTo(CharSequence charSequence, String hyperlinkTarget) {
        this.hasHyperlinkTo(charSequence, this.hyperlinkRegion(charSequence), hyperlinkTarget);
    }

    public void hasHyperlinkTo(CharSequence charSequence, IRegion hyperlinkRegion, String hyperlinkTarget) {
        IHyperlink[] hyperlinks = this.hyperlinkingOn(this.dslFile(charSequence), hyperlinkRegion.getOffset());
        this.hyperlinkIsOffered(hyperlinks, hyperlinkRegion, hyperlinkTarget);
    }

    protected IFile dslFile(CharSequence text) {
        String content = text.toString().replace(this.c, "");
        return super.dslFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content);
    }

    protected IHyperlink[] hyperlinkingOn(IFile dslFile, int offset) {
        XtextEditor editor = this.openInEditor(dslFile);
        IXtextDocument document = this.xtextDocumentUtil.getXtextDocument((ITextViewer)editor.getInternalSourceViewer());
        XtextResource resource = (XtextResource)document.readOnly(state -> state);
        return this.hyperlinkHelper.createHyperlinksByOffset(resource, offset, true);
    }

    protected XtextEditor openInEditor(IFile dslFile) {
        IResourcesSetupUtil.waitForBuild();
        try {
            return this.openEditor(dslFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void hyperlinkIsOffered(IHyperlink[] hyperlinks, IRegion expectedRegion, String expectedHyperlinkTarget) {
        AbstractHyperlinkingTest.assertNotNull((String)"No hyperlinks found!", (Object)hyperlinks);
        AbstractHyperlinkingTest.assertEquals((long)1L, (long)hyperlinks.length);
        IHyperlink hyperlink = hyperlinks[0];
        AbstractHyperlinkingTest.assertEquals((Object)expectedRegion, (Object)hyperlink.getHyperlinkRegion());
        AbstractHyperlinkingTest.assertEquals((Object)expectedHyperlinkTarget, (Object)this.target(hyperlink));
    }

    protected String target(IHyperlink hyperlink) {
        if (hyperlink instanceof JdtHyperlink) {
            return this._target((JdtHyperlink)hyperlink);
        }
        if (hyperlink instanceof XtextHyperlink) {
            return this._target((XtextHyperlink)hyperlink);
        }
        return this._target(hyperlink);
    }

    protected String _target(JdtHyperlink hyperlink) {
        IJavaElement javaElement = hyperlink.getJavaElement();
        AbstractHyperlinkingTest.assertTrue((boolean)(javaElement instanceof IType));
        return ((IType)javaElement).getFullyQualifiedName();
    }

    protected String _target(XtextHyperlink hyperlink) {
        ResourceSet resourceSet = this.resourceSetProvider.get(this.project);
        EObject eObject = resourceSet.getEObject(hyperlink.getURI(), true);
        return this.qualifiedNameProvider.getFullyQualifiedName(eObject).toString();
    }

    protected String _target(IHyperlink hyperlink) {
        AbstractHyperlinkingTest.fail((String)("Unsupported hyperlink " + String.valueOf(hyperlink.getClass())));
        return null;
    }

    protected String getProjectName() {
        return "HyperlinkingTestProject";
    }

    protected String getFileName() {
        return "hyperlinking";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }

    protected IRegion hyperlinkRegion(CharSequence input) {
        int second;
        String text = input.toString();
        int first = text.indexOf(this.c);
        if (first == -1) {
            AbstractHyperlinkingTest.fail((String)("Can't locate the first position symbol '" + this.c + "' in the input text"));
        }
        if (first == (second = text.lastIndexOf(this.c))) {
            AbstractHyperlinkingTest.fail((String)("Can't locate the second position symbol '" + this.c + "' in the input text"));
        }
        int offset = first;
        int length = second - first - this.c.length();
        return new Region(offset, length);
    }
}

