/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.util;

import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.LookAheadInfo;
import org.eclipse.xtext.nodemodel.impl.InvariantChecker;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.testing.util.ResourceHelper;

public class ParseHelper<T extends EObject> {
    @Inject
    private ResourceHelper resourceHelper;
    @Inject
    private InvariantChecker invariantChecker;
    public String fileExtension;

    @Inject
    public void setFileExtensionProvider(FileExtensionProvider extensionProvider) {
        this.fileExtension = extensionProvider.getPrimaryFileExtension();
    }

    public T parse(InputStream in, URI uriToUse, Map<?, ?> options, ResourceSet resourceSet) {
        ICompositeNode rootNode;
        IParseResult parseResult;
        this.resourceHelper.setFileExtension(this.fileExtension);
        Resource resource = this.resourceHelper.resource(in, uriToUse, options, resourceSet);
        if (resource instanceof XtextResource && (parseResult = ((XtextResource)resource).getParseResult()) != null && (rootNode = parseResult.getRootNode()) != null) {
            this.checkNodeModel(rootNode);
        }
        EObject root = resource.getContents().isEmpty() ? null : (EObject)resource.getContents().get(0);
        return (T)root;
    }

    public T parse(CharSequence text) throws Exception {
        return this.parse(text, (ResourceSet)this.resourceHelper.createResourceSet());
    }

    public T parse(CharSequence text, ResourceSet resourceSetToUse) throws Exception {
        return this.parse(this.getAsStream(text), this.computeUnusedUri(resourceSetToUse), null, resourceSetToUse);
    }

    public T parse(CharSequence text, URI uriToUse, ResourceSet resourceSetToUse) throws Exception {
        return this.parse(this.getAsStream(text), uriToUse, null, resourceSetToUse);
    }

    protected URI computeUnusedUri(ResourceSet resourceSet) {
        return this.resourceHelper.computeUnusedUri(resourceSet);
    }

    protected InputStream getAsStream(CharSequence text) {
        return this.resourceHelper.getAsStream(text);
    }

    protected InvariantChecker getInvariantChecker() {
        return this.invariantChecker;
    }

    protected void checkNodeModel(ICompositeNode rootNode) {
        this.getInvariantChecker().checkInvariant((INode)rootNode);
        new LookAheadInfo(rootNode).checkConsistency();
    }
}

