/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.uml.NamedElement;
import org.junit.Assert;

public class DiagramUtils {
    public static IGraphicalEditPart findEditPartforView(IMultiDiagramEditor papyrusEditor, View view, Class<? extends EditPart> editPartClass) {
        DiagramEditPart diagramEditPart = DiagramUtils.findDiagramEditPart(papyrusEditor);
        Object part = diagramEditPart.getViewer().getEditPartRegistry().get(view);
        Assert.assertNotNull((String)"Cannot find the edit part", part);
        Assert.assertNotNull((String)"part has not the right class", (Object)editPartClass.isAssignableFrom(part.getClass()));
        return (IGraphicalEditPart)part;
    }

    public static DiagramEditPart findDiagramEditPart(IMultiDiagramEditor papyrusEditor) {
        DiagramEditPart diagramEditPart = (DiagramEditPart)papyrusEditor.getAdapter(DiagramEditPart.class);
        Assert.assertNotNull((String)"Cannot find the Diagram edit part", (Object)diagramEditPart);
        return diagramEditPart;
    }

    public static Shape findShape(View container, String elementName) {
        for (Object viewObject : container.getChildren()) {
            NamedElement element;
            View view = (View)viewObject;
            if (!(view instanceof Shape) || !(view.getElement() instanceof NamedElement) || !elementName.equals((element = (NamedElement)view.getElement()).getName())) continue;
            return (Shape)view;
        }
        return null;
    }

    public static Edge findEdge(View container, String elementName) {
        for (Object viewObject : container.eContents()) {
            NamedElement element;
            View view;
            if (!(viewObject instanceof View) || !((view = (View)viewObject) instanceof Edge) || !(view.getElement() instanceof NamedElement) || !elementName.equals((element = (NamedElement)view.getElement()).getName())) continue;
            return (Edge)view;
        }
        return null;
    }

    public static int rgb(int red, int green, int blue) {
        return red | green << 8 | blue << 16;
    }

    public static RGB integerToRGB(int value) {
        int blue = value & 0xFF;
        int green = value >> 8 & 0xFF;
        int red = value >> 16 & 0xFF;
        return new RGB(red, green, blue);
    }

    public static String integerToRGBString(int value) {
        RGB rgb = DiagramUtils.integerToRGB(value);
        return rgb.toString();
    }

    public static Diagram getNotationDiagram(ModelSet modelSet, String string) {
        IModel notationModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        AbstractBaseModel notationBaseModel = null;
        if (!(notationModel instanceof AbstractBaseModel)) {
            Assert.fail((String)"notation model is not an abstract base model");
            return null;
        }
        notationBaseModel = (AbstractBaseModel)notationModel;
        Assert.assertTrue((String)"notation resource contains nothing", (notationBaseModel.getResource().getContents().size() >= 1 ? 1 : 0) != 0);
        for (EObject object : notationBaseModel.getResource().getContents()) {
            if (!(object instanceof Diagram) || !string.equals(((Diagram)object).getName())) continue;
            return (Diagram)object;
        }
        return null;
    }

    public static Collection<Diagram> getAllNotationDiagram(ModelSet modelSet, String string) {
        IModel notationModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        ArrayList<Diagram> arrayList = new ArrayList<Diagram>();
        AbstractBaseModel notationBaseModel = null;
        if (!(notationModel instanceof AbstractBaseModel)) {
            Assert.fail((String)"notation model is not an abstract base model");
            return null;
        }
        notationBaseModel = (AbstractBaseModel)notationModel;
        Assert.assertTrue((String)"notation resource contains nothing", (notationBaseModel.getResource().getContents().size() >= 1 ? 1 : 0) != 0);
        for (EObject object : notationBaseModel.getResource().getContents()) {
            if (!(object instanceof Diagram) || !string.equals(((Diagram)object).getName())) continue;
            arrayList.add((Diagram)object);
        }
        return arrayList;
    }
}

