/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.cli;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cbi.p2repo.util.LogLevel;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.cbi.p2repo.util.P2RepoUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.equinox.app.IApplication;
import org.kohsuke.args4j.Option;
import org.osgi.framework.Bundle;

public abstract class AbstractCommand
implements Comparable<AbstractCommand> {
    public static final Integer EXIT_OK = IApplication.EXIT_OK;
    public static final Integer EXIT_ERROR = 13;
    @Option(name="-?", aliases={"--help"}, usage="Print help screen for specified command")
    private boolean help;
    @Option(name="--stacktrace", usage="Display stack trace on error")
    private boolean displayStacktrace;
    @Option(name="--logLevel", usage="Controls the verbosity of the console trace output. Defaults to global settings.")
    private LogLevel logLevel;
    @Option(name="--eclipseLogLevel", usage="Controls the verbosity of the eclipse log trace output. Defaults to global settings.")
    private LogLevel eclipseLogLevel;
    @Option(name="--ignored", usage="This has no effect.", hidden=true)
    private boolean ignored;
    @Option(name="--ignore", usage="This has no efffect and ignores all values.", hidden=true)
    private String[] ignore;
    private String name;

    @Override
    public final int compareTo(AbstractCommand another) {
        return another == null ? 1 : this.getName().compareTo(another.getName());
    }

    public final LogLevel getEclipseLogLevel() {
        return this.eclipseLogLevel;
    }

    public InputStream getHelpStream() {
        return null;
    }

    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final String getName() {
        return this.name;
    }

    public ProgressProvider getProgressProvider() {
        return new ProgressProvider(){

            public IProgressMonitor createMonitor(Job job) {
                return this.getDefaultMonitor();
            }
        };
    }

    public abstract String getShortDescription();

    public String getUsageTitle() {
        return String.valueOf(this.getName()) + " [options...]";
    }

    public boolean isDisplayStacktrace() {
        return this.displayStacktrace;
    }

    public boolean isHelp() {
        return this.help;
    }

    private void printConfiguration() {
        LogUtils.debug((String)"Configuration:", (Object[])new Object[0]);
        Bundle[] bundles = P2RepoUtil.getPlugin().getBundle().getBundleContext().getBundles();
        ArrayList<String> configLines = new ArrayList<String>(bundles.length);
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            configLines.add(String.valueOf(bundle.getSymbolicName()) + " / " + bundle.getVersion());
            ++n2;
        }
        Collections.sort(configLines);
        for (String configLine : configLines) {
            LogUtils.debug((String)configLine, (Object[])new Object[0]);
        }
        LogUtils.debug((String)"", (Object[])new Object[0]);
    }

    public final int run() throws Exception {
        IProgressMonitor monitor = this.getProgressProvider().getDefaultMonitor();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        LogLevel originalConsoleLogLevel = P2RepoUtil.getPlugin().getConsoleLogLevel();
        LogLevel originalEclipseLogLevel = P2RepoUtil.getPlugin().getEclipseLogLevel();
        try {
            if (this.logLevel != null) {
                P2RepoUtil.getPlugin().setConsoleLogLevel(this.logLevel);
            }
            if (this.eclipseLogLevel != null) {
                P2RepoUtil.getPlugin().setEclipseLogLevel(this.logLevel);
            }
            if (P2RepoUtil.getPlugin().getConsoleLogLevel().ordinal() <= LogLevel.DEBUG.ordinal() || P2RepoUtil.getPlugin().getEclipseLogLevel().ordinal() <= LogLevel.DEBUG.ordinal()) {
                this.printConfiguration();
            }
            int n = this.run(monitor);
            return n;
        }
        finally {
            monitor.done();
            if (this.logLevel != null) {
                P2RepoUtil.getPlugin().setConsoleLogLevel(originalConsoleLogLevel);
            }
            if (this.eclipseLogLevel != null) {
                P2RepoUtil.getPlugin().setEclipseLogLevel(originalEclipseLogLevel);
            }
        }
    }

    protected abstract int run(IProgressMonitor var1) throws Exception;

    final void setName(String name) {
        this.name = name;
    }
}

