/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.p2view.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.AggregatorFactory;
import org.eclipse.cbi.p2repo.aggregator.InstallableUnitType;
import org.eclipse.cbi.p2repo.aggregator.MetadataRepositoryReference;
import org.eclipse.cbi.p2repo.aggregator.Property;
import org.eclipse.cbi.p2repo.aggregator.p2view.Bundle;
import org.eclipse.cbi.p2repo.aggregator.p2view.Categories;
import org.eclipse.cbi.p2repo.aggregator.p2view.Category;
import org.eclipse.cbi.p2repo.aggregator.p2view.Feature;
import org.eclipse.cbi.p2repo.aggregator.p2view.Fragment;
import org.eclipse.cbi.p2repo.aggregator.p2view.IUPresentation;
import org.eclipse.cbi.p2repo.aggregator.p2view.MetadataRepositoryStructuredView;
import org.eclipse.cbi.p2repo.aggregator.p2view.OtherIU;
import org.eclipse.cbi.p2repo.aggregator.p2view.P2viewFactory;
import org.eclipse.cbi.p2repo.aggregator.p2view.Product;
import org.eclipse.cbi.p2repo.aggregator.p2view.RepositoryReferences;
import org.eclipse.cbi.p2repo.aggregator.util.InstallableUnitUtils;
import org.eclipse.cbi.p2repo.aggregator.util.ResourceUtils;
import org.eclipse.cbi.p2repo.aggregator.util.TwoColumnMatrix;
import org.eclipse.cbi.p2repo.p2.MetadataRepository;
import org.eclipse.cbi.p2repo.p2.impl.InstallableUnitImpl;
import org.eclipse.cbi.p2repo.p2.util.IUUtils;
import org.eclipse.cbi.p2repo.p2.util.P2Utils;
import org.eclipse.cbi.p2repo.p2.util.RepositoryTranslationSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryable;

public class MetadataRepositoryStructuredViewBuilder {
    private final Resource resource;
    private final MetadataRepositoryStructuredView repoView;
    private final MetadataRepository repository;
    private final TwoColumnMatrix<IUPresentation, Object[]> allIUMatrix;

    public static MetadataRepositoryStructuredView create(MetadataRepository repository) {
        MetadataRepositoryStructuredView repoView = P2viewFactory.eINSTANCE.createMetadataRepositoryStructuredView(repository);
        new MetadataRepositoryStructuredViewBuilder(null, repoView, repository, new TwoColumnMatrix<IUPresentation, Object[]>()).buildStructuredView();
        return repoView;
    }

    public static void build(Resource resource, MetadataRepositoryStructuredView repoView, MetadataRepository repository, TwoColumnMatrix<IUPresentation, Object[]> allIUMatrix) {
        new MetadataRepositoryStructuredViewBuilder(resource, repoView, repository, allIUMatrix).buildStructuredView();
    }

    private MetadataRepositoryStructuredViewBuilder(Resource resource, MetadataRepositoryStructuredView repoView, MetadataRepository repository, TwoColumnMatrix<IUPresentation, Object[]> allIUMatrix) {
        this.resource = resource;
        this.repoView = repoView;
        this.repository = repository;
        this.allIUMatrix = allIUMatrix;
    }

    private void buildStructuredView() {
        EList references;
        Categories categoryContainer;
        this.repoView.setName(this.repository.getName());
        this.repoView.setInstallableUnitList(P2viewFactory.eINSTANCE.createInstallableUnits());
        HashMap<String, Map<Version, IUPresentation>> iuMap = new HashMap<String, Map<Version, IUPresentation>>();
        ArrayList<Category> categories = new ArrayList<Category>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Product> products = new ArrayList<Product>();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        ArrayList<OtherIU> miscellaneous = new ArrayList<OtherIU>();
        EList<IUPresentation> allIUs = this.repoView.getInstallableUnitList().getAllIUs();
        for (IInstallableUnit iu : this.repository.getInstallableUnits()) {
            Object iuPresentation;
            switch (InstallableUnitUtils.getType(iu)) {
                case CATEGORY: {
                    iuPresentation = P2viewFactory.eINSTANCE.createCategory(iu);
                    if (iuPresentation.isNested()) break;
                    categories.add((Category)iuPresentation);
                    break;
                }
                case FEATURE: {
                    iuPresentation = P2viewFactory.eINSTANCE.createFeature(iu);
                    features.add((Feature)iuPresentation);
                    break;
                }
                case PRODUCT: {
                    iuPresentation = P2viewFactory.eINSTANCE.createProduct(iu);
                    products.add((Product)iuPresentation);
                    break;
                }
                case BUNDLE: {
                    iuPresentation = P2viewFactory.eINSTANCE.createBundle(iu);
                    bundles.add((Bundle)iuPresentation);
                    break;
                }
                case FRAGMENT: {
                    iuPresentation = P2viewFactory.eINSTANCE.createFragment(iu);
                    fragments.add((Fragment)iuPresentation);
                    break;
                }
                default: {
                    iuPresentation = P2viewFactory.eINSTANCE.createOtherIU(iu);
                    miscellaneous.add((OtherIU)iuPresentation);
                }
            }
            iuPresentation.setId(iu.getId());
            iuPresentation.setVersion(iu.getVersion());
            iuPresentation.setFilter(P2Utils.filterToString((IMatchExpression)iu.getFilter()));
            String name = RepositoryTranslationSupport.getInstance((IQueryable)((MetadataRepository)((InstallableUnitImpl)iu).eContainer())).getIUProperty(iu, "org.eclipse.equinox.p2.name");
            if (name == null || name.length() == 0) {
                iuPresentation.setName(iu.getId());
            } else {
                iuPresentation.setName(name);
            }
            if (name != null && name.startsWith("%")) {
                name = null;
            }
            if (InstallableUnitUtils.getType(iu) == InstallableUnitType.CATEGORY || iu.getVersion() == null) {
                iuPresentation.setLabel(name != null && name.length() > 0 ? name : iu.getId());
            } else {
                iuPresentation.setLabel(String.valueOf(iu.getId()) + " / " + IUUtils.stringifyVersion((Version)iu.getVersion()) + (name != null && name.length() > 0 ? " (" + name + ")" : ""));
            }
            iuPresentation.setDescription(RepositoryTranslationSupport.getInstance((IQueryable)((MetadataRepository)((InstallableUnitImpl)iu).eContainer())).getIUProperty(iu, "org.eclipse.equinox.p2.description"));
            HashMap<Version, Object> versionMap = (HashMap<Version, Object>)iuMap.get(iu.getId());
            if (versionMap == null) {
                versionMap = new HashMap<Version, Object>();
                iuMap.put(iu.getId(), versionMap);
            }
            versionMap.put(iu.getVersion(), iuPresentation);
            allIUs.add((IUPresentation)iuPresentation);
        }
        if (categories.size() > 0) {
            Collections.sort(categories, IUPresentation.COMPARATOR);
            this.repoView.getInstallableUnitList().getNotNullCategoryContainer().getCategories().addAll(categories);
            this.addIUsToMap(this.repoView.getInstallableUnitList().getCategoryContainer(), categories);
        }
        if (features.size() > 0) {
            Collections.sort(features, IUPresentation.COMPARATOR);
            this.repoView.getInstallableUnitList().getNotNullFeatureContainer().getFeatures().addAll(features);
            this.addIUsToMap(this.repoView.getInstallableUnitList().getFeatureContainer(), features);
        }
        if (products.size() > 0) {
            Collections.sort(products, IUPresentation.COMPARATOR);
            this.repoView.getInstallableUnitList().getNotNullProductContainer().getProducts().addAll(products);
            this.addIUsToMap(this.repoView.getInstallableUnitList().getProductContainer(), products);
        }
        if (bundles.size() > 0) {
            Collections.sort(bundles, IUPresentation.COMPARATOR);
            this.repoView.getInstallableUnitList().getNotNullBundleContainer().getBundles().addAll(bundles);
            this.addIUsToMap(this.repoView.getInstallableUnitList().getBundleContainer(), bundles);
        }
        if (fragments.size() > 0) {
            Collections.sort(fragments, IUPresentation.COMPARATOR);
            this.repoView.getInstallableUnitList().getNotNullFragmentContainer().getFragments().addAll(fragments);
            this.addIUsToMap(this.repoView.getInstallableUnitList().getFragmentContainer(), fragments);
        }
        if (miscellaneous.size() > 0) {
            Collections.sort(miscellaneous, IUPresentation.COMPARATOR);
            this.repoView.getInstallableUnitList().getNotNullMiscellaneousContainer().getOthers().addAll(miscellaneous);
            this.addIUsToMap(this.repoView.getInstallableUnitList().getMiscellaneousContainer(), miscellaneous);
        }
        if ((categoryContainer = this.repoView.getInstallableUnitList().getCategoryContainer()) != null) {
            for (Category category : categoryContainer.getCategories()) {
                HashSet visited = new HashSet();
                this.exploreCategory(category, iuMap, visited);
            }
        }
        ArrayList<Property> propList = new ArrayList<Property>();
        for (Map.Entry property : this.repository.getPropertyMap()) {
            propList.add(AggregatorFactory.eINSTANCE.createProperty((String)property.getKey(), (String)property.getValue()));
        }
        if (propList.size() > 0) {
            this.repoView.setProperties(P2viewFactory.eINSTANCE.createProperties());
            Collections.sort(propList);
            this.repoView.getProperties().getPropertyList().addAll(propList);
        }
        if ((references = this.repository.getReferences()).size() > 0) {
            RepositoryReferences repoRefs = P2viewFactory.eINSTANCE.createRepositoryReferences();
            this.repoView.setRepositoryReferences(repoRefs);
            repoRefs.getRepositoryReferences().addAll((Collection)references);
        }
        this.repoView.setLoaded(true);
        Aggregation aggregation = ResourceUtils.getAggregation(this.getResourceSet());
        if (aggregation != null) {
            for (MetadataRepositoryReference mdrReference : aggregation.getAllMetadataRepositoryReferences(true)) {
                String refLocation = mdrReference.getLocation();
                if (refLocation != null && refLocation.endsWith("/")) {
                    refLocation = refLocation.substring(0, refLocation.length() - 1);
                }
                if (!this.repository.getLocation().toString().equals(refLocation)) continue;
                mdrReference.setLocation(mdrReference.getLocation());
            }
        }
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected ResourceSet getResourceSet() {
        Resource resource = this.getResource();
        return resource == null ? null : resource.getResourceSet();
    }

    protected void addIUsToMap(Object container, List<? extends IUPresentation> iuPresentations) {
        Object[] treePath = new Object[]{this.getResource(), this.repoView, this.repoView.getInstallableUnitList(), container};
        for (IUPresentation iUPresentation : iuPresentations) {
            this.allIUMatrix.add(iUPresentation, treePath);
        }
    }

    protected void exploreCategory(Category category, Map<String, Map<Version, IUPresentation>> iuMap, Set<Category> visited) {
        visited.add(category);
        ArrayList<Category> categories = new ArrayList<Category>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Product> products = new ArrayList<Product>();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        int idx = this.allIUMatrix.indexOf(category);
        Object[] oldTreePath = this.allIUMatrix.getValue(idx);
        int len = oldTreePath.length;
        Object[] categoryTreePath = new Object[len + 1];
        System.arraycopy(oldTreePath, 0, categoryTreePath, 0, len);
        categoryTreePath[len] = category;
        for (IRequirement requirement : category.getInstallableUnit().getRequirements()) {
            for (IUPresentation iuPresentation : this.findMatchingIUs(requirement, iuMap)) {
                if (visited.contains(iuPresentation)) continue;
                this.allIUMatrix.add(++idx, iuPresentation, categoryTreePath);
                if (iuPresentation instanceof Category) {
                    categories.add((Category)iuPresentation);
                    this.exploreCategory((Category)iuPresentation, iuMap, visited);
                    continue;
                }
                if (iuPresentation instanceof Feature) {
                    features.add((Feature)iuPresentation);
                    continue;
                }
                if (iuPresentation instanceof Product) {
                    products.add((Product)iuPresentation);
                    continue;
                }
                if (iuPresentation instanceof Fragment) {
                    fragments.add((Fragment)iuPresentation);
                    continue;
                }
                if (!(iuPresentation instanceof Bundle)) continue;
                bundles.add((Bundle)iuPresentation);
            }
        }
        if (categories.size() > 0) {
            Collections.sort(categories, IUPresentation.COMPARATOR);
            category.getNotNullCategoryContainer().getCategories().addAll(categories);
        }
        if (features.size() > 0) {
            Collections.sort(features, IUPresentation.COMPARATOR);
            category.getNotNullFeatureContainer().getFeatures().addAll(features);
        }
        if (products.size() > 0) {
            Collections.sort(products, IUPresentation.COMPARATOR);
            category.getNotNullProductContainer().getProducts().addAll(products);
        }
        if (bundles.size() > 0) {
            Collections.sort(bundles, IUPresentation.COMPARATOR);
            category.getNotNullBundleContainer().getBundles().addAll(bundles);
        }
        if (fragments.size() > 0) {
            Collections.sort(fragments, IUPresentation.COMPARATOR);
            category.getNotNullFragmentContainer().getFragments().addAll(fragments);
        }
    }

    private List<IUPresentation> findMatchingIUs(IRequirement rq, Map<String, Map<Version, IUPresentation>> iuMap) {
        Map<Version, IUPresentation> vps2;
        ArrayList<IUPresentation> found = new ArrayList<IUPresentation>();
        if (rq instanceof IRequiredCapability && (vps2 = iuMap.get(((IRequiredCapability)rq).getName())) != null) {
            for (Map.Entry<Version, IUPresentation> vp : vps2.entrySet()) {
                if (!vp.getValue().getInstallableUnit().satisfies(rq)) continue;
                found.add(vp.getValue());
            }
        }
        for (Map<Version, IUPresentation> vps2 : iuMap.values()) {
            for (Map.Entry<Version, IUPresentation> vp : vps2.entrySet()) {
                if (!vp.getValue().getInstallableUnit().satisfies(rq)) continue;
                found.add(vp.getValue());
            }
        }
        return found;
    }
}

