/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.handlers;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.dev.project.management.Activator;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractAddFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        Job job = new Job(this.getJobName()){

            protected IStatus run(IProgressMonitor monitor) {
                return AbstractAddFileHandler.this.runAsJob(monitor);
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)AbstractAddFileHandler.this.getJobName(), (String)"Done.");
                    }
                });
            }
        });
        return null;
    }

    protected IStatus runAsJob(IProgressMonitor monitor) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        URL sourceURL = this.getSourceURL();
        if (sourceURL == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot find the source file", (String)"The source file is invalid");
        }
        String targetPath = this.getTargetPath();
        monitor.beginTask(this.getJobName(), projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject current = iProjectArray[n2];
            if (current.isOpen() && this.isValidProject(current)) {
                try {
                    this.addFile(current, sourceURL, targetPath);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (MalformedURLException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            monitor.worked(1);
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected String getJobName() {
        return "Add files";
    }

    protected abstract boolean isValidProject(IProject var1);

    protected abstract URL getSourceURL();

    protected abstract String getTargetPath();

    protected void addFile(IProject project, URL url, String fileDestinationPath) throws CoreException, IOException {
        Assert.isNotNull((Object)url);
        Assert.isNotNull((Object)fileDestinationPath);
        Assert.isNotNull((Object)project);
        ProjectEditor editor = new ProjectEditor(project);
        editor.init();
        editor.addFile(url, fileDestinationPath, true);
        editor.save();
    }
}

