/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.widgets.editors;

import org.eclipse.papyrus.infra.gmfdiag.widgets.Activator;
import org.eclipse.papyrus.infra.gmfdiag.widgets.editors.ColorPickerEditor;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class XWTAwareColorPicker
extends AbstractPropertyEditor {
    private ColorPickerEditor editor;
    private String imagePath;
    private int x = -1;
    private int y = -1;
    private int width = -1;
    private int height = -1;

    public XWTAwareColorPicker(Composite parent, int style) {
        this.editor = new ColorPickerEditor(parent, style);
        this.setEditor(this.editor);
    }

    public void setImage(String imagePath) {
        this.imagePath = imagePath;
        Image image = Activator.getDefault().getImageFromPlugin(imagePath);
        if (image != null) {
            this.editor.setImage(image);
        }
    }

    protected void doBinding() {
        super.doBinding();
        Object defaultValue = this.input.getDefaultValue(this.propertyPath);
        if (defaultValue instanceof Integer) {
            this.editor.setDefaultColor((Integer)defaultValue);
        }
    }

    public String getImage() {
        return this.imagePath;
    }

    protected void checkBounds() {
        if (this.x > -1 && this.y > -1 && this.width > -1 && this.height > -1) {
            this.editor.setColorBounds(new Rectangle(this.x, this.y, this.width, this.height));
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

