/**
 * Copyright (c) 2007, 2013, 2015, 2021 Borland Software Corporation, Christian W. Damus, CEA LIST, Artal and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Michael Golubev (Montages) - initial API and implementation
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Thibault Landre (Atos Origin) - add Papyrus dependencies to Papyrus GMF diagram
 * Vincent Lorenzo (CEA-LIST) vincent.lorenzo@cea.fr : add the dependency org.eclipse.papyrus.infra.services.edit
 * Christian W. Damus - bug 477384
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.2 cleanup dependency declarations in Require-Bundle section
 * Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Bug 574258: [Toolsmiths] Improve GMF generation for manifest.MF and build.properties
 */
package xpt.plugin;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.papyrus.gmf.codegen.util.AbstractManifest;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.GenEditorGenerator_qvto;

@Singleton
@SuppressWarnings("all")
public class manifest extends AbstractManifest {
  @Inject
  @Extension
  private GenEditorGenerator_qvto _genEditorGenerator_qvto;
  
  public CharSequence qualifiedClassName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("META-INF/MANIFEST.MF");
    return _builder;
  }
  
  public CharSequence fullPath(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence manifest(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    this.init(it.getID());
    _builder.newLineIfNotEmpty();
    CharSequence _manifestVersion = this.manifestVersion(it);
    _builder.append(_manifestVersion);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleManifestVersion = this.bundleManifestVersion(it);
    _builder.append(_bundleManifestVersion);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleName = this.bundleName(it);
    _builder.append(_bundleName);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleDescription = this.bundleDescription(it);
    _builder.append(_bundleDescription);
    _builder.newLineIfNotEmpty();
    CharSequence _symbolicName = this.symbolicName(it);
    _builder.append(_symbolicName);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleVersion = this.bundleVersion(it);
    _builder.append(_bundleVersion);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleClassPath = this.bundleClassPath(it);
    _builder.append(_bundleClassPath);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleActivator = this.bundleActivator(it);
    _builder.append(_bundleActivator);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleVendor = this.bundleVendor(it);
    _builder.append(_bundleVendor);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleLocalization = this.bundleLocalization(it);
    _builder.append(_bundleLocalization);
    _builder.newLineIfNotEmpty();
    CharSequence _exportPackages = this.exportPackages(it);
    _builder.append(_exportPackages);
    _builder.newLineIfNotEmpty();
    CharSequence _requireBundle = this.requireBundle(it);
    _builder.append(_requireBundle);
    _builder.newLineIfNotEmpty();
    CharSequence _importPackage = this.importPackage();
    _builder.append(_importPackage);
    _builder.newLineIfNotEmpty();
    CharSequence _bundleActivatorPolicy = this.bundleActivatorPolicy(it);
    _builder.append(_bundleActivatorPolicy);
    _builder.newLineIfNotEmpty();
    CharSequence _eclipseLazyStart = this.eclipseLazyStart(it);
    _builder.append(_eclipseLazyStart);
    _builder.newLineIfNotEmpty();
    CharSequence _executionEnvironment = this.executionEnvironment(it);
    _builder.append(_executionEnvironment);
    _builder.newLineIfNotEmpty();
    CharSequence _automaticModuleName = this.automaticModuleName(it);
    _builder.append(_automaticModuleName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence automaticModuleName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Automatic-Module-Name: ");
    String _iD = it.getID();
    _builder.append(_iD);
    return _builder;
  }
  
  public CharSequence manifestVersion(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Manifest-Version: 1.0");
    return _builder;
  }
  
  public CharSequence bundleManifestVersion(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-ManifestVersion: 2");
    return _builder;
  }
  
  public CharSequence bundleName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-Name: %pluginName");
    return _builder;
  }
  
  public CharSequence bundleDescription(final GenPlugin it) {
    CharSequence _xifexpression = null;
    boolean _hasBundleDescription = this.hasBundleDescription();
    if (_hasBundleDescription) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Bundle-Description: ");
      String _bundleDescription = this.getBundleDescription();
      _builder.append(_bundleDescription);
      _builder.newLineIfNotEmpty();
      _xifexpression = _builder;
    }
    return _xifexpression;
  }
  
  public CharSequence symbolicName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-SymbolicName: ");
    String _iD = it.getID();
    _builder.append(_iD);
    _builder.append("; singleton:=true");
    return _builder;
  }
  
  public CharSequence bundleVersion(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-Version: ");
    String _version = it.getVersion();
    _builder.append(_version);
    return _builder;
  }
  
  public CharSequence bundleClassPath(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-ClassPath: .");
    return _builder;
  }
  
  public CharSequence bundleActivator(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-Activator: ");
    String _activatorQualifiedClassName = it.getActivatorQualifiedClassName();
    _builder.append(_activatorQualifiedClassName);
    return _builder;
  }
  
  public CharSequence bundleVendor(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-Vendor: %providerName");
    return _builder;
  }
  
  public CharSequence bundleLocalization(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-Localization: plugin");
    return _builder;
  }
  
  public CharSequence bundleActivatorPolicy(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-ActivationPolicy: lazy");
    return _builder;
  }
  
  public CharSequence eclipseLazyStart(final GenPlugin it) {
    CharSequence _xifexpression = null;
    boolean _isEclipseLazyStart = this.isEclipseLazyStart();
    if (_isEclipseLazyStart) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Eclipse-LazyStart: true");
      _builder.newLine();
      _xifexpression = _builder;
    }
    return _xifexpression;
  }
  
  public CharSequence exportPackages(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    String _buildExportPackage = this.buildExportPackage(it);
    _builder.append(_buildExportPackage);
    return _builder;
  }
  
  public String buildExportPackage(final GenPlugin it) {
    final Collection<String> exportedPackage = this.getExistingExportedPackages();
    exportedPackage.add(it.getEditorGen().getDiagram().getEditPartsPackageName());
    exportedPackage.add(it.getEditorGen().getEditor().getPackageName());
    exportedPackage.add(it.getEditorGen().getDiagram().getProvidersPackageName());
    final StringBuilder builder = new StringBuilder("Export-Package: ");
    final Iterator<String> iter = exportedPackage.iterator();
    while (iter.hasNext()) {
      {
        builder.append(iter.next());
        boolean _hasNext = iter.hasNext();
        if (_hasNext) {
          builder.append(",");
          builder.append("\n");
          builder.append(" ");
        } else {
          builder.append("\n");
        }
      }
    }
    return builder.toString();
  }
  
  public CharSequence requireBundle(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    String _buildRequiredBundle = this.buildRequiredBundle();
    _builder.append(_buildRequiredBundle);
    return _builder;
  }
  
  public CharSequence importPackage() {
    StringConcatenation _builder = new StringConcatenation();
    String _declareImportPackage = this.declareImportPackage();
    _builder.append(_declareImportPackage);
    return _builder;
  }
  
  public CharSequence executionEnvironment(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Bundle-RequiredExecutionEnvironment: ");
    {
      int _jdkComplianceLevel = this._genEditorGenerator_qvto.jdkComplianceLevel(it.getEditorGen());
      boolean _greaterThan = (_jdkComplianceLevel > 8);
      if (_greaterThan) {
        _builder.append("JavaSE-");
        int _jdkComplianceLevel_1 = this._genEditorGenerator_qvto.jdkComplianceLevel(it.getEditorGen());
        _builder.append(_jdkComplianceLevel_1);
      } else {
        _builder.append("J2SE-1.");
        int _jdkComplianceLevel_2 = this._genEditorGenerator_qvto.jdkComplianceLevel(it.getEditorGen());
        _builder.append(_jdkComplianceLevel_2);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
